/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.util;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;

public class ByteBufferDeserializer {
    private static final int INT_BYTES = 4;
    private static final int LONG_BYTES = 8;
    private final ReaderRegistry<String> stringRegistry;
    private final Logger logger;
    private final CachedRecordFactoryCatalog recordFactories;
    private final ByteBuffer buffer;
    private IMonitoringRecordReceiver recordReceiver;

    public ByteBufferDeserializer(ReaderRegistry<String> readerRegistry, Logger logger, int bufferCapacity) {
        this.stringRegistry = readerRegistry;
        this.logger = logger;
        this.recordFactories = new CachedRecordFactoryCatalog();
        this.buffer = ByteBuffer.allocateDirect(bufferCapacity);
    }

    public void deserialize(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = this.buffer;
        while (channel.read(buffer) != -1) {
            this.process(buffer);
        }
    }

    private void process(ByteBuffer buffer) {
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                buffer.mark();
                boolean success = this.onBufferReceived(buffer);
                if (success) continue;
                buffer.reset();
                buffer.compact();
                return;
            }
            buffer.clear();
        }
        catch (BufferUnderflowException ex) {
            this.logger.warn("Unexpected buffer underflow. Resetting and compacting buffer.", ex);
            buffer.reset();
            buffer.compact();
        }
    }

    private boolean onBufferReceived(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int clazzId = buffer.getInt();
        if (buffer.remaining() < 8) {
            return false;
        }
        long loggingTimestamp = buffer.getLong();
        String recordClassName = this.stringRegistry.get(clazzId);
        if (recordClassName != null) {
            IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
            if (recordFactory != null) {
                if (buffer.remaining() < recordFactory.getRecordSizeInBytes()) {
                    return false;
                }
            } else {
                return false;
            }
            try {
                IMonitoringRecord record = recordFactory.create(BinaryValueDeserializer.create(buffer, this.stringRegistry));
                record.setLoggingTimestamp(loggingTimestamp);
                this.recordReceiver.newMonitoringRecord(record);
            }
            catch (RecordInstantiationException ex) {
                this.logger.error("Failed to create: {}", (Object)recordClassName, (Object)ex);
                throw ex;
            }
            return true;
        }
        this.logger.error("Failed to identify a event type {}, no classname registered.", (Object)clazzId);
        throw new RecordInstantiationException("Cannot identify record class. Unknown id" + clazzId, new Object[0]);
    }

    public void register(IMonitoringRecordReceiver recordReceiver) {
        this.recordReceiver = recordReceiver;
    }
}

