/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.analysis.source.file.AbstractEventDeserializer;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.OutputPort;

public class BinaryEventDeserializer
extends AbstractEventDeserializer {
    public static final String BUFFER_SIZE = BinaryEventDeserializer.class.getCanonicalName() + ".bufferSize";
    public static final int DEFAULT_BUFFER_SIZE = 102400;
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryEventDeserializer.class);
    private static final int LONG_BYTES = 8;
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final ByteBuffer buffer;

    public BinaryEventDeserializer(Integer bufferSize, ReaderRegistry<String> registry) {
        super(registry);
        this.buffer = ByteBuffer.allocate(bufferSize == null ? 102400 : bufferSize);
    }

    @Override
    public void processDataStream(InputStream chainInputStream, OutputPort<IMonitoringRecord> outputPort) throws IOException {
        BinaryValueDeserializer deserializer = BinaryValueDeserializer.create(this.buffer, this.registry);
        boolean endOfStreamReached = false;
        while (!endOfStreamReached) {
            byte[] bytes = this.buffer.array();
            int bytesRead = chainInputStream.read(bytes, this.buffer.position(), this.buffer.remaining());
            this.buffer.position(this.buffer.position() + bytesRead);
            while (bytesRead > 0) {
                bytes = this.buffer.array();
                bytesRead = chainInputStream.read(bytes, this.buffer.position(), this.buffer.remaining());
                if (bytesRead < 0) continue;
                this.buffer.position(this.buffer.position() + bytesRead);
            }
            if (bytesRead == -1) {
                endOfStreamReached = true;
            }
            this.processBuffer(deserializer, outputPort);
            if (!endOfStreamReached) continue;
            chainInputStream.close();
        }
    }

    private void processBuffer(IValueDeserializer deserializer, OutputPort<IMonitoringRecord> outputPort) throws IOException {
        this.buffer.flip();
        try {
            while (this.buffer.position() + 4 <= this.buffer.limit()) {
                this.buffer.mark();
                IMonitoringRecord record = this.deserializeRecord(deserializer);
                if (record == null) {
                    return;
                }
                outputPort.send((Object)record);
            }
            this.buffer.mark();
            this.buffer.compact();
        }
        catch (BufferUnderflowException ex) {
            LOGGER.warn("Unexpected buffer underflow. Resetting and compacting buffer.", ex);
            this.buffer.reset();
            this.buffer.compact();
            throw ex;
        }
    }

    private IMonitoringRecord deserializeRecord(IValueDeserializer deserializer) throws IOException {
        int clazzId = this.buffer.getInt();
        String eventTypeName = (String)this.registry.get(clazzId);
        if (eventTypeName == null) {
            LOGGER.error("Missing classname mapping for record type id '{}'", (Object)clazzId);
            return null;
        }
        if (this.buffer.remaining() < 8) {
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        long loggingTimestamp = this.buffer.getLong();
        IRecordFactory<? extends IMonitoringRecord> eventTypeFactory = this.recordFactories.get(eventTypeName);
        if (eventTypeFactory == null) {
            LOGGER.error("Class type {} was not found. Cannot instantiate event type.", (Object)eventTypeName);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        if (this.buffer.remaining() < eventTypeFactory.getRecordSizeInBytes()) {
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        try {
            IMonitoringRecord record = eventTypeFactory.create(deserializer);
            record.setLoggingTimestamp(loggingTimestamp);
            return record;
        }
        catch (RecordInstantiationException ex) {
            LOGGER.warn("Buffer too small to hold complete event: {} error {}", (Object)eventTypeName, (Object)ex);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        catch (BufferUnderflowException ex) {
            LOGGER.warn("Received event is incomplete: {} error {}", (Object)eventTypeName, (Object)ex);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
    }
}

