/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.flow;

import kieker.analysis.stage.general.IControlEventMatcher;
import kieker.analysis.stage.model.data.OperationEvent;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowTraceEventMatcher
implements IControlEventMatcher<OperationEvent, IFlowRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowTraceEventMatcher.class);

    @Override
    public boolean requiresControlEvent(IFlowRecord baseEvent) {
        return !(baseEvent instanceof TraceMetadata);
    }

    @Override
    public boolean checkControlEvent(OperationEvent controlEvent, IFlowRecord baseEvent) {
        if (baseEvent instanceof BeforeOperationEvent) {
            BeforeOperationEvent beforeOperationEvent = (BeforeOperationEvent)baseEvent;
            return controlEvent.getComponentSignature().equals(beforeOperationEvent.getClassSignature()) && controlEvent.getOperationSignature().equals(beforeOperationEvent.getOperationSignature());
        }
        if (baseEvent instanceof AfterOperationEvent) {
            AfterOperationEvent afterOperationEvent = (AfterOperationEvent)baseEvent;
            return controlEvent.getComponentSignature().equals(afterOperationEvent.getClassSignature()) && controlEvent.getOperationSignature().equals(afterOperationEvent.getOperationSignature());
        }
        LOGGER.error("Events of type {} are not supported.", (Object)baseEvent.getClass().getSimpleName());
        return false;
    }

    @Override
    public boolean keepControlEvent(IFlowRecord baseEvent) {
        return baseEvent instanceof BeforeOperationEvent;
    }
}

