/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace;

import java.util.Stack;
import kieker.analysis.stage.flow.TraceEventRecords;
import kieker.analysis.trace.AbstractTraceAnalysisStage;
import kieker.analysis.trace.AbstractTraceProcessingStage;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.concurrency.SplitEvent;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorFailedEvent;
import kieker.common.record.flow.trace.operation.constructor.BeforeConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.CallConstructorEvent;
import kieker.common.util.signature.ClassOperationSignaturePair;
import kieker.common.util.signature.Signature;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.Execution;
import kieker.model.system.model.ExecutionTrace;
import kieker.model.system.model.InvalidExecutionTrace;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.exceptions.InvalidTraceException;
import org.slf4j.Logger;
import teetime.framework.OutputPort;

public class TraceEventRecords2ExecutionAndMessageTraceStage
extends AbstractTraceProcessingStage<TraceEventRecords> {
    private final OutputPort<ExecutionTrace> executionTraceOutputPort = this.createOutputPort(ExecutionTrace.class);
    private final OutputPort<MessageTrace> messageTraceOutputPort = this.createOutputPort(MessageTrace.class);
    private final OutputPort<InvalidExecutionTrace> invalidExecutionTraceOutputPort = this.createOutputPort(InvalidExecutionTrace.class);
    private final boolean enhanceJavaConstructors;
    private final boolean enhanceCallDetection;
    private final boolean ignoreAssumedCalls;

    public TraceEventRecords2ExecutionAndMessageTraceStage(SystemModelRepository repository, boolean enhanceJavaConstructors, boolean enhanceCallDetection, boolean ignoreAssumedCalls) {
        super(repository);
        this.enhanceJavaConstructors = enhanceJavaConstructors;
        this.enhanceCallDetection = enhanceCallDetection;
        this.ignoreAssumedCalls = ignoreAssumedCalls;
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        super.onTerminating();
    }

    protected void execute(TraceEventRecords traceEventRecords) throws Exception {
        TraceMetadata trace = traceEventRecords.getTraceMetadata();
        if (trace == null) {
            this.logger.error("Trace is missing from TraceEvents");
            return;
        }
        long traceId = trace.getTraceId();
        ExecutionTrace executionTrace = new ExecutionTrace(traceId, trace.getSessionId());
        TraceEventRecordHandler traceEventRecordHandler = new TraceEventRecordHandler(this.logger, trace, executionTrace, this.getSystemModelRepository(), this.enhanceJavaConstructors, this.enhanceCallDetection, this.ignoreAssumedCalls);
        int expectedOrderIndex = -1;
        for (AbstractTraceEvent event : traceEventRecords.getTraceEvents()) {
            if (event.getOrderIndex() != ++expectedOrderIndex) {
                this.logger.error("Found event with wrong orderIndex. Found: {} expected: {}", (Object)event.getOrderIndex(), (Object)(expectedOrderIndex - 1));
                continue;
            }
            if (event.getTraceId() != traceId) {
                this.logger.error("Found event with wrong traceId. Found: {} expected: {}", (Object)event.getTraceId(), (Object)traceId);
                continue;
            }
            try {
                if (BeforeConstructorEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleBeforeConstructorEvent((BeforeConstructorEvent)event);
                    continue;
                }
                if (BeforeOperationEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleBeforeOperationEvent((BeforeOperationEvent)event);
                    continue;
                }
                if (AfterConstructorFailedEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterConstructorFailedEvent((AfterConstructorFailedEvent)event);
                    continue;
                }
                if (AfterOperationFailedEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterOperationFailedEvent((AfterOperationFailedEvent)event);
                    continue;
                }
                if (AfterConstructorEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterConstructorEvent((AfterConstructorEvent)event);
                    continue;
                }
                if (AfterOperationEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterOperationEvent((AfterOperationEvent)event);
                    continue;
                }
                if (CallConstructorEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleCallConstructorEvent((CallConstructorEvent)event);
                    continue;
                }
                if (CallOperationEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleCallOperationEvent((CallOperationEvent)event);
                    continue;
                }
                if (SplitEvent.class.isAssignableFrom(event.getClass())) {
                    this.logger.warn("Events of type 'SplitEvent' are currently not handled and ignored.");
                    continue;
                }
                this.logger.warn("Events of type '{}' are currently not handled and ignored.", (Object)event.getClass().getName());
            }
            catch (InvalidTraceException ex) {
                this.logger.error("Failed to reconstruct trace.", ex);
                this.invalidExecutionTraceOutputPort.send((Object)new InvalidExecutionTrace(executionTrace));
                return;
            }
        }
        try {
            traceEventRecordHandler.finish();
            MessageTrace messageTrace = executionTrace.toMessageTrace(SystemModelRepository.ROOT_EXECUTION);
            this.executionTraceOutputPort.send((Object)executionTrace);
            this.messageTraceOutputPort.send((Object)messageTrace);
            super.reportSuccess(executionTrace.getTraceId());
        }
        catch (InvalidTraceException ex) {
            this.logger.warn("Failed to convert to message trace: {}", (Object)ex.getMessage());
            this.invalidExecutionTraceOutputPort.send((Object)new InvalidExecutionTrace(executionTrace));
        }
    }

    public OutputPort<ExecutionTrace> getExecutionTraceOutputPort() {
        return this.executionTraceOutputPort;
    }

    public OutputPort<InvalidExecutionTrace> getInvalidExecutionTraceOutputPort() {
        return this.invalidExecutionTraceOutputPort;
    }

    public OutputPort<MessageTrace> getMessageTraceOutputPort() {
        return this.messageTraceOutputPort;
    }

    private static class TraceEventRecordHandler {
        private final SystemModelRepository systemModelRepository;
        private final TraceMetadata trace;
        private final ExecutionTrace executionTrace;
        private final Stack<AbstractTraceEvent> eventStack = new Stack();
        private final Stack<ExecutionInformation> executionStack = new Stack();
        private final boolean enhanceJavaConstructors;
        private final boolean enhanceCallDetection;
        private int orderindex;
        private final boolean ignoreAssumedCalls;
        private final Logger logger;

        public TraceEventRecordHandler(Logger logger, TraceMetadata trace, ExecutionTrace executionTrace, SystemModelRepository systemModelRepository, boolean enhanceJavaConstructors, boolean enhanceCallDetection, boolean ignoreAssumedCalls) {
            this.trace = trace;
            this.executionTrace = executionTrace;
            this.systemModelRepository = systemModelRepository;
            this.enhanceJavaConstructors = enhanceJavaConstructors;
            this.enhanceCallDetection = enhanceCallDetection;
            this.ignoreAssumedCalls = ignoreAssumedCalls;
            this.logger = logger;
        }

        public void finish() throws InvalidTraceException {
            Stack<AbstractTraceEvent> tmpEventStack = new Stack<AbstractTraceEvent>();
            Stack<ExecutionInformation> tmpExecutionStack = new Stack<ExecutionInformation>();
            if (!this.eventStack.isEmpty()) {
                long lastTimeStamp = this.eventStack.peek().getTimestamp();
                while (!this.eventStack.isEmpty()) {
                    tmpEventStack.push(this.eventStack.pop());
                    tmpExecutionStack.push(this.executionStack.pop());
                }
                while (!tmpEventStack.isEmpty()) {
                    AbstractTraceEvent currentEvent = (AbstractTraceEvent)tmpEventStack.pop();
                    ExecutionInformation executionInformation = (ExecutionInformation)tmpExecutionStack.pop();
                    if (currentEvent instanceof CallOperationEvent) {
                        this.finishExecution(((CallOperationEvent)currentEvent).getCalleeOperationSignature(), ((CallOperationEvent)currentEvent).getCalleeClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), currentEvent.getTimestamp(), lastTimeStamp, !this.ignoreAssumedCalls, currentEvent instanceof CallConstructorEvent);
                        continue;
                    }
                    throw new InvalidTraceException("Only CallOperationEvents are expected to be remaining, but found: " + currentEvent.getClass().getSimpleName());
                }
            }
        }

        private AbstractTraceEvent peekEvent() {
            if (this.eventStack.isEmpty()) {
                return null;
            }
            return this.eventStack.peek();
        }

        private void registerExecution(AbstractTraceEvent cause) {
            this.eventStack.push(cause);
            ExecutionInformation executionInformation = new ExecutionInformation(this.orderindex++, this.executionStack.size());
            this.executionStack.push(executionInformation);
        }

        private void finishExecution(String operationSignature, String classSignature, long traceId, String sessionId, String hostname, int eoi, int ess, long tin, long tout, boolean assumed, boolean constructor) throws InvalidTraceException {
            ClassOperationSignaturePair fqComponentNameSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr(operationSignature, constructor && this.enhanceJavaConstructors);
            String executionContext = classSignature.length() == 0 ? fqComponentNameSignaturePair.getFqClassname() : classSignature;
            Execution execution = AbstractTraceAnalysisStage.createExecutionByEntityNames(this.systemModelRepository, hostname, executionContext, fqComponentNameSignaturePair.getFqClassname(), fqComponentNameSignaturePair.getSignature(), traceId, sessionId, eoi, ess, tin, tout, assumed);
            try {
                this.executionTrace.add(execution);
            }
            catch (InvalidTraceException ex) {
                throw new InvalidTraceException("Failed to add execution " + execution + " to trace " + this.executionTrace + ".", ex);
            }
        }

        private void closeOpenCalls(AbstractOperationEvent lastEvent) throws InvalidTraceException {
            AbstractTraceEvent prevEvent;
            Stack<CallOperationEvent> tmpEventStack = new Stack<CallOperationEvent>();
            Stack<ExecutionInformation> tmpExecutionStack = new Stack<ExecutionInformation>();
            while (!this.eventStack.isEmpty() && (prevEvent = this.eventStack.peek()) instanceof CallOperationEvent) {
                tmpEventStack.push((CallOperationEvent)this.eventStack.pop());
                tmpExecutionStack.push(this.executionStack.pop());
                if (!lastEvent.getOperationSignature().equals(((CallOperationEvent)prevEvent).getOperationSignature())) continue;
                while (!tmpEventStack.isEmpty()) {
                    CallOperationEvent currentCallEvent = (CallOperationEvent)tmpEventStack.pop();
                    ExecutionInformation executionInformation = (ExecutionInformation)tmpExecutionStack.pop();
                    this.finishExecution(currentCallEvent.getCalleeOperationSignature(), currentCallEvent.getCalleeClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), currentCallEvent.getTimestamp(), lastEvent.getTimestamp(), !this.ignoreAssumedCalls, currentCallEvent instanceof CallConstructorEvent);
                }
                return;
            }
            while (!tmpEventStack.isEmpty()) {
                this.eventStack.push((AbstractTraceEvent)tmpEventStack.pop());
                this.executionStack.push((ExecutionInformation)tmpExecutionStack.pop());
            }
        }

        private void handleBeforeEvent(BeforeOperationEvent beforeOperationEvent, Class<? extends CallOperationEvent> callClass) throws InvalidTraceException {
            AbstractTraceEvent prevEvent = this.peekEvent();
            if (this.isPrevEventMatchingCall(beforeOperationEvent, prevEvent, callClass)) {
                this.eventStack.push(beforeOperationEvent);
            } else {
                this.closeOpenCalls(beforeOperationEvent);
                this.registerExecution(beforeOperationEvent);
            }
        }

        public void handleBeforeOperationEvent(BeforeOperationEvent beforeOperationEvent) throws InvalidTraceException {
            this.handleBeforeEvent(beforeOperationEvent, CallOperationEvent.class);
        }

        public void handleBeforeConstructorEvent(BeforeConstructorEvent beforeConstructorEvent) throws InvalidTraceException {
            this.handleBeforeEvent(beforeConstructorEvent, CallConstructorEvent.class);
        }

        private boolean isPrevEventMatchingCall(BeforeOperationEvent beforeOperationEvent, AbstractTraceEvent prevEvent, Class<? extends CallOperationEvent> callClass) {
            if (prevEvent != null && callClass.isAssignableFrom(prevEvent.getClass()) && prevEvent.getOrderIndex() == beforeOperationEvent.getOrderIndex() - 1) {
                if (this.callsReferencedOperationOf((CallOperationEvent)prevEvent, beforeOperationEvent)) {
                    return true;
                }
                if (this.enhanceCallDetection) {
                    Signature afterSignature;
                    boolean isConstructor = beforeOperationEvent instanceof BeforeConstructorEvent;
                    CallOperationEvent callEvent = (CallOperationEvent)prevEvent;
                    Signature callSignature = ClassOperationSignaturePair.splitOperationSignatureStr(callEvent.getCalleeOperationSignature(), isConstructor && this.enhanceJavaConstructors).getSignature();
                    if (callSignature.equals(afterSignature = ClassOperationSignaturePair.splitOperationSignatureStr(beforeOperationEvent.getOperationSignature(), isConstructor && this.enhanceJavaConstructors).getSignature()) && callEvent.getCalleeClassSignature().equals(beforeOperationEvent.getClassSignature())) {
                        this.logger.debug("Guessed call of \n\t{}\n\t{}", (Object)callEvent, (Object)beforeOperationEvent);
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean callsReferencedOperationOf(CallOperationEvent prevEvent, BeforeOperationEvent presentEvent) {
            return prevEvent.getCalleeOperationSignature().equals(presentEvent.getOperationSignature()) && prevEvent.getCalleeClassSignature().equals(presentEvent.getClassSignature());
        }

        private void handleAfterEvent(AfterOperationEvent afterOperationEvent, Class<? extends BeforeOperationEvent> beforeClass, Class<? extends CallOperationEvent> callClass) throws InvalidTraceException {
            boolean definiteCall;
            this.closeOpenCalls(afterOperationEvent);
            AbstractTraceEvent potentialBeforeEvent = this.peekEvent();
            if (potentialBeforeEvent == null || !beforeClass.isAssignableFrom(potentialBeforeEvent.getClass())) {
                throw new InvalidTraceException("Didn't find corresponding " + beforeClass.getName() + " for " + afterOperationEvent.getClass().getName() + " " + afterOperationEvent.toString() + " (found: " + potentialBeforeEvent + ").");
            }
            if (!this.refersToSameOperationAs(afterOperationEvent, (BeforeOperationEvent)potentialBeforeEvent)) {
                throw new InvalidTraceException("Components of before (" + potentialBeforeEvent + ") and after (" + afterOperationEvent + ") events do not match.");
            }
            BeforeOperationEvent beforeOperationEvent = (BeforeOperationEvent)this.eventStack.pop();
            AbstractTraceEvent prevEvent = this.peekEvent();
            boolean bl = definiteCall = prevEvent == null || this.isPrevEventMatchingCall(beforeOperationEvent, prevEvent, callClass);
            if (definiteCall && !this.eventStack.isEmpty()) {
                this.eventStack.pop();
            }
            ExecutionInformation executionInformation = this.executionStack.pop();
            this.finishExecution(beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), beforeOperationEvent.getTimestamp(), afterOperationEvent.getTimestamp(), !definiteCall && !this.ignoreAssumedCalls, beforeOperationEvent instanceof BeforeConstructorEvent);
        }

        private boolean refersToSameOperationAs(AfterOperationEvent afterOperationEvent, BeforeOperationEvent potentialBeforeEvent) {
            return afterOperationEvent.getOperationSignature().equals(potentialBeforeEvent.getOperationSignature()) && afterOperationEvent.getClassSignature().equals(potentialBeforeEvent.getClassSignature());
        }

        public void handleAfterOperationEvent(AfterOperationEvent afterOperationEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterOperationEvent, BeforeOperationEvent.class, CallOperationEvent.class);
        }

        public void handleAfterOperationFailedEvent(AfterOperationFailedEvent afterOperationEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterOperationEvent, BeforeOperationEvent.class, CallOperationEvent.class);
        }

        public void handleAfterConstructorEvent(AfterConstructorEvent afterConstructorEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterConstructorEvent, BeforeConstructorEvent.class, CallConstructorEvent.class);
        }

        public void handleAfterConstructorFailedEvent(AfterConstructorFailedEvent afterConstructorEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterConstructorEvent, BeforeConstructorEvent.class, CallConstructorEvent.class);
        }

        public void handleCallOperationEvent(CallOperationEvent callOperationEvent) throws InvalidTraceException {
            this.closeOpenCalls(callOperationEvent);
            this.registerExecution(callOperationEvent);
        }

        public void handleCallConstructorEvent(CallConstructorEvent callConstructorEvent) throws InvalidTraceException {
            this.handleCallOperationEvent(callConstructorEvent);
        }

        private static class ExecutionInformation {
            private final int eoi;
            private final int ess;

            public ExecutionInformation(int executionIndex, int stackDepth) {
                this.eoi = executionIndex;
                this.ess = stackDepth;
            }

            public int getEoi() {
                return this.eoi;
            }

            public int getEss() {
                return this.ess;
            }
        }
    }
}

