/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.AbstractEvent;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.record.io.IValueDeserializer;

public abstract class AbstractTraceEvent
extends AbstractEvent
implements ITraceRecord {
    public static final long TRACE_ID = -1L;
    public static final int ORDER_INDEX = -1;
    private static final long serialVersionUID = 3123204150489927280L;
    private long traceId;
    private final int orderIndex;

    public AbstractTraceEvent(long timestamp, long traceId, int orderIndex) {
        super(timestamp);
        this.traceId = traceId;
        this.orderIndex = orderIndex;
    }

    public AbstractTraceEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.traceId = deserializer.getLong();
        this.orderIndex = deserializer.getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractTraceEvent castedRecord = (AbstractTraceEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        return this.getOrderIndex() == castedRecord.getOrderIndex();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        return code += this.getOrderIndex();
    }

    @Override
    public final long getTraceId() {
        return this.traceId;
    }

    @Override
    public final void setTraceId(long traceId) {
        this.traceId = traceId;
    }

    @Override
    public final int getOrderIndex() {
        return this.orderIndex;
    }

    @Override
    public String toString() {
        String result = "AbstractTraceEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        return result;
    }
}

