/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BeforeReceivedRemoteEvent
extends AbstractMonitoringRecord {
    public static final int SIZE = 32;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "callerTraceId", "callerOrderIndex", "traceId", "orderIndex"};
    public static final long TIMESTAMP = -1L;
    public static final long CALLER_TRACE_ID = -1L;
    public static final int CALLER_ORDER_INDEX = -1;
    public static final long TRACE_ID = -1L;
    public static final int ORDER_INDEX = -1;
    private static final long serialVersionUID = -2469910628320520231L;
    private final long timestamp;
    private final long callerTraceId;
    private final int callerOrderIndex;
    private final long traceId;
    private final int orderIndex;

    public BeforeReceivedRemoteEvent(long timestamp, long callerTraceId, int callerOrderIndex, long traceId, int orderIndex) {
        this.timestamp = timestamp;
        this.callerTraceId = callerTraceId;
        this.callerOrderIndex = callerOrderIndex;
        this.traceId = traceId;
        this.orderIndex = orderIndex;
    }

    public BeforeReceivedRemoteEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.callerTraceId = deserializer.getLong();
        this.callerOrderIndex = deserializer.getInt();
        this.traceId = deserializer.getLong();
        this.orderIndex = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getCallerTraceId());
        serializer.putInt(this.getCallerOrderIndex());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BeforeReceivedRemoteEvent castedRecord = (BeforeReceivedRemoteEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getCallerTraceId() != castedRecord.getCallerTraceId()) {
            return false;
        }
        if (this.getCallerOrderIndex() != castedRecord.getCallerOrderIndex()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        return this.getOrderIndex() == castedRecord.getOrderIndex();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getCallerTraceId();
        code += this.getCallerOrderIndex();
        code += (int)this.getTraceId();
        return code += this.getOrderIndex();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final long getCallerTraceId() {
        return this.callerTraceId;
    }

    public final int getCallerOrderIndex() {
        return this.callerOrderIndex;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final int getOrderIndex() {
        return this.orderIndex;
    }

    @Override
    public String toString() {
        String result = "BeforeReceivedRemoteEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "callerTraceId = ";
        result = result + this.getCallerTraceId() + ", ";
        result = result + "callerOrderIndex = ";
        result = result + this.getCallerOrderIndex() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        return result;
    }
}

