/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.jvm.AbstractJVMRecord;

public class CompilationRecord
extends AbstractJVMRecord {
    public static final int SIZE = 28;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, String.class, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "vmName", "jitCompilerName", "totalCompilationTimeMS"};
    public static final String JIT_COMPILER_NAME = "";
    private static final long serialVersionUID = 3634137431488075031L;
    private final String jitCompilerName;
    private final long totalCompilationTimeMS;

    public CompilationRecord(long timestamp, String hostname, String vmName, String jitCompilerName, long totalCompilationTimeMS) {
        super(timestamp, hostname, vmName);
        this.jitCompilerName = jitCompilerName == null ? JIT_COMPILER_NAME : jitCompilerName;
        this.totalCompilationTimeMS = totalCompilationTimeMS;
    }

    public CompilationRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.jitCompilerName = deserializer.getString();
        this.totalCompilationTimeMS = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getVmName());
        serializer.putString(this.getJitCompilerName());
        serializer.putLong(this.getTotalCompilationTimeMS());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CompilationRecord castedRecord = (CompilationRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (!this.getVmName().equals(castedRecord.getVmName())) {
            return false;
        }
        if (!this.getJitCompilerName().equals(castedRecord.getJitCompilerName())) {
            return false;
        }
        return this.getTotalCompilationTimeMS() == castedRecord.getTotalCompilationTimeMS();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getVmName().hashCode();
        code += this.getJitCompilerName().hashCode();
        return code += (int)this.getTotalCompilationTimeMS();
    }

    public final String getJitCompilerName() {
        return this.jitCompilerName;
    }

    public final long getTotalCompilationTimeMS() {
        return this.totalCompilationTimeMS;
    }

    @Override
    public String toString() {
        String result = "CompilationRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "vmName = ";
        result = result + this.getVmName() + ", ";
        result = result + "jitCompilerName = ";
        result = result + this.getJitCompilerName() + ", ";
        result = result + "totalCompilationTimeMS = ";
        result = result + this.getTotalCompilationTimeMS() + ", ";
        return result;
    }
}

