/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class ThreadMetaData
extends AbstractMonitoringRecord {
    public static final int SIZE = 12;
    public static final Class<?>[] TYPES = new Class[]{String.class, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"hostname", "threadId"};
    public static final String HOSTNAME = "";
    private static final long serialVersionUID = 4284309919791475271L;
    private final String hostname;
    private final long threadId;

    public ThreadMetaData(String hostname, long threadId) {
        this.hostname = hostname == null ? HOSTNAME : hostname;
        this.threadId = threadId;
    }

    public ThreadMetaData(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.hostname = deserializer.getString();
        this.threadId = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getHostname());
        serializer.putLong(this.getThreadId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ThreadMetaData castedRecord = (ThreadMetaData)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        return this.getThreadId() == castedRecord.getThreadId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getHostname().hashCode();
        return code += (int)this.getThreadId();
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    @Override
    public String toString() {
        String result = "ThreadMetaData: ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "threadId = ";
        result = result + this.getThreadId() + ", ";
        return result;
    }
}

