/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class MemSwapUsageRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 60;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "memTotal", "memUsed", "memFree", "swapTotal", "swapUsed", "swapFree"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final long MEM_TOTAL = 0L;
    public static final long MEM_USED = 0L;
    public static final long MEM_FREE = 0L;
    public static final long SWAP_TOTAL = 0L;
    public static final long SWAP_USED = 0L;
    public static final long SWAP_FREE = 0L;
    private static final long serialVersionUID = 638480390439299363L;
    private final long timestamp;
    private final String hostname;
    private final long memTotal;
    private final long memUsed;
    private final long memFree;
    private final long swapTotal;
    private final long swapUsed;
    private final long swapFree;

    public MemSwapUsageRecord(long timestamp, String hostname, long memTotal, long memUsed, long memFree, long swapTotal, long swapUsed, long swapFree) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? HOSTNAME : hostname;
        this.memTotal = memTotal;
        this.memUsed = memUsed;
        this.memFree = memFree;
        this.swapTotal = swapTotal;
        this.swapUsed = swapUsed;
        this.swapFree = swapFree;
    }

    public MemSwapUsageRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.memTotal = deserializer.getLong();
        this.memUsed = deserializer.getLong();
        this.memFree = deserializer.getLong();
        this.swapTotal = deserializer.getLong();
        this.swapUsed = deserializer.getLong();
        this.swapFree = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putLong(this.getMemTotal());
        serializer.putLong(this.getMemUsed());
        serializer.putLong(this.getMemFree());
        serializer.putLong(this.getSwapTotal());
        serializer.putLong(this.getSwapUsed());
        serializer.putLong(this.getSwapFree());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 60;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MemSwapUsageRecord castedRecord = (MemSwapUsageRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (this.getMemTotal() != castedRecord.getMemTotal()) {
            return false;
        }
        if (this.getMemUsed() != castedRecord.getMemUsed()) {
            return false;
        }
        if (this.getMemFree() != castedRecord.getMemFree()) {
            return false;
        }
        if (this.getSwapTotal() != castedRecord.getSwapTotal()) {
            return false;
        }
        if (this.getSwapUsed() != castedRecord.getSwapUsed()) {
            return false;
        }
        return this.getSwapFree() == castedRecord.getSwapFree();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += (int)this.getMemTotal();
        code += (int)this.getMemUsed();
        code += (int)this.getMemFree();
        code += (int)this.getSwapTotal();
        code += (int)this.getSwapUsed();
        return code += (int)this.getSwapFree();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final long getMemTotal() {
        return this.memTotal;
    }

    public final long getMemUsed() {
        return this.memUsed;
    }

    public final long getMemFree() {
        return this.memFree;
    }

    public final long getSwapTotal() {
        return this.swapTotal;
    }

    public final long getSwapUsed() {
        return this.swapUsed;
    }

    public final long getSwapFree() {
        return this.swapFree;
    }

    @Override
    public String toString() {
        String result = "MemSwapUsageRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "memTotal = ";
        result = result + this.getMemTotal() + ", ";
        result = result + "memUsed = ";
        result = result + this.getMemUsed() + ", ";
        result = result + "memFree = ";
        result = result + this.getMemFree() + ", ";
        result = result + "swapTotal = ";
        result = result + this.getSwapTotal() + ", ";
        result = result + "swapUsed = ";
        result = result + this.getSwapUsed() + ", ";
        result = result + "swapFree = ";
        result = result + this.getSwapFree() + ", ";
        return result;
    }
}

