/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra;

import com.datastax.driver.core.BoundStatement;
import kieker.common.record.io.IValueSerializer;

public class CassandraValueSerializer
implements IValueSerializer {
    private final BoundStatement boundStatement;
    private int column;

    public CassandraValueSerializer(BoundStatement boundStatement) {
        this.boundStatement = boundStatement;
        this.column = 1;
    }

    @Override
    public void putBoolean(boolean value) {
        this.boundStatement.setBool(this.column++, value);
    }

    @Override
    public void putByte(byte value) {
        this.boundStatement.setByte(this.column++, value);
    }

    @Override
    public void putChar(char value) {
        this.boundStatement.setString(this.column++, String.valueOf(value));
    }

    @Override
    public void putShort(short value) {
        this.boundStatement.setShort(this.column++, value);
    }

    @Override
    public void putInt(int value) {
        this.boundStatement.setInt(this.column++, value);
    }

    @Override
    public void putLong(long value) {
        this.boundStatement.setLong(this.column++, value);
    }

    @Override
    public void putFloat(float value) {
        this.boundStatement.setFloat(this.column++, value);
    }

    @Override
    public void putDouble(double value) {
        this.boundStatement.setDouble(this.column++, value);
    }

    @Override
    public <T extends Enum<T>> void putEnumeration(T value) {
        this.boundStatement.setInt(this.column++, value.ordinal());
    }

    @Override
    public void putBytes(byte[] value) {
        throw new UnsupportedOperationException("Plain byte arrays cannot be stored in Cassandra DB.");
    }

    @Override
    public void putString(String value) {
        this.boundStatement.setString(this.column++, value);
    }
}

