/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.configuration.Configuration;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IStateController;
import kieker.monitoring.core.controller.IStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateController
extends AbstractController
implements IStateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateController.class);
    private volatile boolean monitoringEnabled;
    private final String name;
    private final String hostname;
    private final String applicationName;
    private final AtomicInteger experimentId = new AtomicInteger(0);
    private final boolean debug;
    private IStateListener stateListener;

    protected StateController(Configuration configuration) {
        super(configuration);
        this.name = configuration.getStringProperty("kieker.monitoring.name");
        this.experimentId.set(configuration.getIntProperty("kieker.monitoring.initialExperimentId"));
        this.applicationName = configuration.getStringProperty("kieker.monitoring.applicationName");
        this.monitoringEnabled = configuration.getBooleanProperty("kieker.monitoring.enabled");
        this.debug = configuration.getBooleanProperty("kieker.monitoring.debug");
        String hostnameTmp = configuration.getStringProperty("kieker.monitoring.hostname");
        if (hostnameTmp.length() == 0) {
            hostnameTmp = "<UNKNOWN>";
            try {
                hostnameTmp = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                LOGGER.warn("Failed to retrieve hostname", ex);
            }
        }
        this.hostname = hostnameTmp;
    }

    @Override
    protected void init() {
    }

    @Override
    protected void cleanup() {
        LOGGER.debug("Shutting down State Controller");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Status: '");
        if (this.isMonitoringTerminated()) {
            sb.append("terminated");
        } else if (this.isMonitoringEnabled()) {
            sb.append("enabled");
        } else {
            sb.append("disabled");
        }
        sb.append("'\n\tName: '").append(this.name).append("'; Hostname: '").append(this.hostname).append("'; experimentID: '").append(this.getExperimentId()).append("'\n");
        return sb.toString();
    }

    @Override
    public boolean terminateMonitoring() {
        if (this.monitoringController != null) {
            return this.monitoringController.terminate();
        }
        LOGGER.warn("Shutting down Monitoring before it is correctly initialized");
        return false;
    }

    @Override
    public boolean isMonitoringTerminated() {
        return super.isTerminated();
    }

    @Override
    public boolean enableMonitoring() {
        if (this.isMonitoringTerminated()) {
            LOGGER.error("Refused to enable monitoring because monitoring has been permanently terminated");
            return false;
        }
        LOGGER.info("Enabling monitoring");
        if (this.stateListener != null) {
            this.stateListener.beforeEnableMonitoring();
        }
        this.monitoringEnabled = true;
        return true;
    }

    @Override
    public boolean disableMonitoring() {
        LOGGER.info("Disabling monitoring");
        this.monitoringEnabled = false;
        return true;
    }

    @Override
    public boolean isMonitoringEnabled() {
        return !super.isTerminated() && this.monitoringEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int incExperimentId() {
        return this.experimentId.incrementAndGet();
    }

    @Override
    public void setExperimentId(int newExperimentID) {
        this.experimentId.set(newExperimentID);
    }

    @Override
    public int getExperimentId() {
        return this.experimentId.get();
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setStateListener(IStateListener stateListener) {
        this.stateListener = stateListener;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

