/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.Enumeration;
import org.aspectj.weaver.loadtime.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AspectJLoader {
    public static final String KIEKER_MONITORING_SKIP_DEFAULT_AOP_CONFIGURATION = "kieker.monitoring.skipDefaultAOPConfiguration";
    private static final String DEFAULT_AOP_CONFIG = "META-INF/aop.example.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectJLoader.class);

    private AspectJLoader() {
    }

    public static void premain(String options, Instrumentation instrumentation) {
        if (!AspectJLoader.checkConfigurationFileAvailable()) {
            URL aspectConfigURL = AspectJLoader.class.getClassLoader().getResource(DEFAULT_AOP_CONFIG);
            LOGGER.info("No AspectJ configuration file found. Using Kieker's default AspectJ configuration file ({}).", (Object)aspectConfigURL);
            AspectJLoader.addKiekerDefaultConfigFile();
        }
        Agent.premain(options, instrumentation);
    }

    private static boolean checkConfigurationFileAvailable() {
        if (Boolean.getBoolean(KIEKER_MONITORING_SKIP_DEFAULT_AOP_CONFIGURATION)) {
            return true;
        }
        LOGGER.info("Using Kieker's AspectJLoader. This is not recommended for multi-classloader environments such as JavaEE and OSGI.Use the additional VM parameter '-D {}=true'. to disable Kieker's AspectJLoader", (Object)KIEKER_MONITORING_SKIP_DEFAULT_AOP_CONFIGURATION);
        if (null != System.getProperty("aj5.def")) {
            return true;
        }
        if (null != System.getProperty("org.aspectj.weaver.loadtime.configuration")) {
            return true;
        }
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            Enumeration<URL> aopUserXMLs = cl.getResources("META-INF/aop.xml");
            Enumeration<URL> aopAJCXMLs = cl.getResources("META-INF/aop-ajc.xml");
            Enumeration<URL> aopOSGIXMLs = cl.getResources("org/aspectj/aop.xml");
            boolean anyConfigFileAvailable = aopUserXMLs.hasMoreElements() || aopAJCXMLs.hasMoreElements() || aopOSGIXMLs.hasMoreElements();
            return anyConfigFileAvailable;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void addKiekerDefaultConfigFile() {
        System.setProperty("org.aspectj.weaver.loadtime.configuration", DEFAULT_AOP_CONFIG);
    }
}

