/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.beforeafter.onlycallee;

import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.probe.aspectj.beforeafter.onlycallee.Counter;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractAspect
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    private final ThreadLocal<Counter> currentStackIndex = new ThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };

    @Pointcut
    public abstract void monitoredOperation();

    @Before(value="monitoredOperation() && notWithinKieker()")
    public void beforeOperation(JoinPoint.StaticPart jpStaticPart) {
        boolean newTrace;
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            CTRLINST.newMonitoringRecord(trace);
        }
        this.currentStackIndex.get().incrementValue();
        long traceId = trace.getTraceId();
        String typeName = jpStaticPart.getSignature().getDeclaringTypeName();
        CTRLINST.newMonitoringRecord(new BeforeOperationEvent(TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, typeName));
    }

    @AfterReturning(value="monitoredOperation() && notWithinKieker()")
    public void afterReturningOperation(JoinPoint.StaticPart jpStaticPart) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        String typeName = jpStaticPart.getSignature().getDeclaringTypeName();
        CTRLINST.newMonitoringRecord(new AfterOperationEvent(TIME.getTime(), trace.getTraceId(), trace.getNextOrderId(), operationSignature, typeName));
    }

    @AfterThrowing(pointcut="monitoredOperation() && notWithinKieker()", throwing="th")
    public void afterThrowing(JoinPoint.StaticPart jpStaticPart, Throwable th) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        String typeName = jpStaticPart.getSignature().getDeclaringTypeName();
        CTRLINST.newMonitoringRecord(new AfterOperationFailedEvent(TIME.getTime(), trace.getTraceId(), trace.getNextOrderId(), operationSignature, typeName, th.toString()));
    }

    @After(value="monitoredOperation() && notWithinKieker()")
    public void afterOperation(JoinPoint.StaticPart jpStaticPart) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        int stackIndex = this.currentStackIndex.get().decrementValue();
        if (stackIndex == 1) {
            TRACEREGISTRY.unregisterTrace();
        }
    }
}

