/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.spring.flow;

import java.io.IOException;
import java.util.List;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestOutInterceptor
implements ClientHttpRequestInterceptor {
    private static final String SIGNATURE = "kieker.monitoring.probe.spring.flow.RestOutInterceptor.interceptOutgoingRequest()";
    private static final Logger LOGGER = LoggerFactory.getLogger(RestOutInterceptor.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String VMNAME = CTRLINST.getHostname();
    private static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    private static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        int nextESS;
        int ess;
        int eoi;
        boolean entrypoint;
        if (!CTRLINST.isMonitoringEnabled()) {
            return execution.execute(request, body);
        }
        String sessionId = SESSION_REGISTRY.recallThreadLocalSessionId();
        long traceId = CF_REGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            entrypoint = true;
            traceId = CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
            CF_REGISTRY.storeThreadLocalEOI(0);
            CF_REGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
            nextESS = 1;
        } else {
            entrypoint = false;
            eoi = CF_REGISTRY.incrementAndRecallThreadLocalEOI();
            ess = CF_REGISTRY.recallAndIncrementThreadLocalESS();
            nextESS = ess + 1;
            if (eoi == -1 || ess == -1) {
                LOGGER.error("eoi and/or ess have invalid values: eoi == {} ess == {}", (Object)eoi, (Object)ess);
                CTRLINST.terminateMonitoring();
            }
        }
        HttpHeaders headers = request.getHeaders();
        headers.add("KiekerTracingInfo", Long.toString(traceId) + "," + sessionId + "," + Integer.toString(eoi) + "," + Integer.toString(nextESS));
        LOGGER.debug("Sending request to {} with header = ", (Object)request.getURI().toString(), (Object)headers.toString());
        long tin = TIME.getTime();
        ClientHttpResponse retval = null;
        try {
            retval = execution.execute(request, body);
        }
        finally {
            long tout = TIME.getTime();
            if (retval instanceof ClientHttpResponse) {
                ClientHttpResponse response = retval;
                HttpHeaders responseHeaders = response.getHeaders();
                if (responseHeaders != null) {
                    List responseHeaderList = responseHeaders.get((Object)"KiekerTracingInfo");
                    if (responseHeaderList != null) {
                        String retSessionId;
                        LOGGER.debug("Received response from {} with header = {}", (Object)responseHeaders.getLocation().toString(), (Object)responseHeaders.toString());
                        String[] responseHeaderArray = ((String)responseHeaderList.get(0)).split(",");
                        String retTraceIdStr = responseHeaderArray[0];
                        Long retTraceId = -1L;
                        if (!"null".equals(retTraceIdStr)) {
                            try {
                                retTraceId = Long.parseLong(retTraceIdStr);
                            }
                            catch (NumberFormatException exc) {
                                LOGGER.warn("Invalid tradeId");
                            }
                        }
                        if (traceId != retTraceId) {
                            LOGGER.error("TraceId in response header ({}) is different from that in request header ({})", (Object)retTraceId, (Object)traceId);
                        }
                        if ("null".equals(retSessionId = responseHeaderArray[1])) {
                            retSessionId = "<no-session-id>";
                        }
                        int retEOI = -1;
                        String retEOIStr = responseHeaderArray[2];
                        if (!"null".equals(retEOIStr)) {
                            try {
                                retEOI = Integer.parseInt(retEOIStr);
                                CF_REGISTRY.storeThreadLocalEOI(retEOI);
                            }
                            catch (NumberFormatException exc) {
                                LOGGER.warn("Invalid eoi", exc);
                            }
                        }
                    } else {
                        LOGGER.debug("No monitoring data found in the response header from {}. Is it instrumented?", (Object)responseHeaders.getLocation().toString());
                    }
                } else {
                    LOGGER.debug("Response header from {} is null. Is it instrumented?", (Object)response.getHeaders().getLocation().toString());
                }
                response.close();
            }
            CTRLINST.newMonitoringRecord(new OperationExecutionRecord(SIGNATURE, sessionId, traceId, tin, tout, VMNAME, eoi, ess));
            if (entrypoint) {
                CF_REGISTRY.unsetThreadLocalTraceId();
                CF_REGISTRY.unsetThreadLocalEOI();
                CF_REGISTRY.unsetThreadLocalESS();
                SESSION_REGISTRY.unsetThreadLocalSessionId();
            } else {
                CF_REGISTRY.storeThreadLocalESS(ess);
            }
        }
        return retval;
    }
}

