/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import kieker.common.record.system.LoadAverageRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.oshi.samplers.AbstractOshiSampler;
import kieker.monitoring.timer.ITimeSource;
import oshi.hardware.HardwareAbstractionLayer;

public final class LoadAverageSampler
extends AbstractOshiSampler {
    public LoadAverageSampler(HardwareAbstractionLayer hardwareAbstractionLayer) {
        super(hardwareAbstractionLayer);
    }

    @Override
    public void sample(IMonitoringController monitoringController) {
        if (!monitoringController.isMonitoringEnabled() || !monitoringController.isProbeActivated(SignatureFactory.createLoadAverageSignature())) {
            return;
        }
        double[] loadAverage = this.hardwareAbstractionLayer.getProcessor().getSystemLoadAverage(3);
        if (loadAverage.length == 3) {
            ITimeSource timesource = monitoringController.getTimeSource();
            LoadAverageRecord r = new LoadAverageRecord(timesource.getTime(), monitoringController.getHostname(), loadAverage[0], loadAverage[1], loadAverage[2]);
            monitoringController.newMonitoringRecord(r);
        }
    }
}

