/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.timer;

import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.monitoring.timer.AbstractTimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemMilliTimer
extends AbstractTimeSource {
    public static final String CONFIG_OFFSET = SystemMilliTimer.class.getName() + ".offset";
    public static final String CONFIG_UNIT = SystemMilliTimer.class.getName() + ".unit";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMilliTimer.class);
    private final long offset;
    private final TimeUnit timeunit;

    public SystemMilliTimer(Configuration configuration) {
        super(configuration);
        this.offset = configuration.getStringProperty(CONFIG_OFFSET).length() == 0 ? System.currentTimeMillis() : configuration.getLongProperty(CONFIG_OFFSET);
        int timeunitval = configuration.getIntProperty(CONFIG_UNIT);
        switch (timeunitval) {
            case 0: {
                this.timeunit = TimeUnit.NANOSECONDS;
                break;
            }
            case 1: {
                this.timeunit = TimeUnit.MICROSECONDS;
                break;
            }
            case 2: {
                this.timeunit = TimeUnit.MILLISECONDS;
                break;
            }
            case 3: {
                this.timeunit = TimeUnit.SECONDS;
                break;
            }
            default: {
                LOGGER.warn("Failed to determine value of {} (0, 1, 2, or 3 expected). Setting to 0=nanoseconds", (Object)CONFIG_UNIT);
                this.timeunit = TimeUnit.NANOSECONDS;
            }
        }
    }

    @Override
    public long getTime() {
        return this.timeunit.convert(System.currentTimeMillis() - this.offset, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getOffset() {
        return this.timeunit.convert(this.offset, TimeUnit.MILLISECONDS);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeunit;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Time in ").append(this.timeunit.toString().toLowerCase(Locale.ENGLISH)).append(" (with milliseconds precision) since ").append(new Date(this.offset));
        return sb.toString();
    }
}

