/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.registry.IRegistryListener;
import kieker.common.registry.writer.WriterRegistry;
import kieker.common.util.classpath.InstantiationFactory;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.compression.ICompressionFilter;
import kieker.monitoring.writer.compression.NoneCompressionFilter;
import kieker.monitoring.writer.filesystem.AbstractLogStreamHandler;
import kieker.monitoring.writer.filesystem.ILogFilePoolHandler;
import kieker.monitoring.writer.filesystem.IMapFileHandler;
import kieker.monitoring.writer.filesystem.KiekerLogFolder;
import kieker.monitoring.writer.filesystem.RotatingLogFilePoolHandler;
import kieker.monitoring.writer.filesystem.TextLogStreamHandler;
import kieker.monitoring.writer.filesystem.TextMapFileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriter
extends AbstractMonitoringWriter
implements IRegistryListener<String> {
    public static final String PREFIX = FileWriter.class.getName() + ".";
    public static final String CONFIG_PATH = PREFIX + "customStoragePath";
    public static final String CONFIG_CHARSET_NAME = PREFIX + "charsetName";
    public static final String CONFIG_MAXENTRIESINFILE = PREFIX + "maxEntriesInFile";
    public static final String CONFIG_MAXLOGSIZE = PREFIX + "maxLogSize";
    public static final String CONFIG_MAXLOGFILES = PREFIX + "maxLogFiles";
    public static final String CONFIG_MAP_FILE_HANDLER = PREFIX + "mapFileHandler";
    public static final String CONFIG_LOG_POOL_FILE_HANDLER = PREFIX + "logFilePoolHandler";
    public static final String CONFIG_LOG_STREAM_HANDLER = PREFIX + "logStreamHandler";
    public static final String CONFIG_FLUSH = PREFIX + "flush";
    public static final String CONFIG_COMPRESSION_FILTER = PREFIX + "compression";
    public static final String CONFIG_BUFFERSIZE = PREFIX + "bufferSize";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileWriter.class);
    private final int maxEntriesInFile;
    private final IMapFileHandler mapFileHandler;
    private final ILogFilePoolHandler logFilePoolHandler;
    private final AbstractLogStreamHandler logStreamHandler;
    private final long maxBytesInFile;
    private final WriterRegistry writerRegistry;
    private final String logFolderName;

    public FileWriter(Configuration configuration) throws IOException {
        super(configuration);
        String configPathName = configuration.getStringProperty(CONFIG_PATH);
        if (configPathName.isEmpty()) {
            configPathName = System.getProperty("java.io.tmpdir");
        }
        if (!new File(configPathName).isDirectory()) {
            String currentWorkingDir = System.getProperty("user.dir");
            throw new IllegalArgumentException("'" + configPathName + "' is not a directory. The current working directory was: " + currentWorkingDir);
        }
        Path logFolder = KiekerLogFolder.buildKiekerLogFolder(configPathName, configuration);
        try {
            this.logFolderName = logFolder.toString();
            Files.createDirectories(logFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error on creating Kieker's log directory.", e);
        }
        this.writerRegistry = new WriterRegistry(this);
        boolean flushLogFile = configuration.getBooleanProperty(CONFIG_FLUSH, false);
        int bufferSize = configuration.getIntProperty(CONFIG_BUFFERSIZE, 65536);
        Charset charset = Charset.forName(configuration.getStringProperty(CONFIG_CHARSET_NAME, "UTF-8"));
        this.maxEntriesInFile = configuration.getIntProperty(CONFIG_MAXENTRIESINFILE) <= 0 ? Integer.MAX_VALUE : configuration.getIntProperty(CONFIG_MAXENTRIESINFILE);
        long maxMegaBytesInFile = configuration.getIntProperty(CONFIG_MAXLOGSIZE);
        this.maxBytesInFile = maxMegaBytesInFile <= 0L ? Integer.MAX_VALUE : maxMegaBytesInFile * 1024L * 1024L;
        int maxAmountOfFiles = configuration.getIntProperty(CONFIG_MAXLOGFILES);
        maxAmountOfFiles = maxAmountOfFiles <= 0 ? Integer.MAX_VALUE : maxAmountOfFiles;
        String charsetName = configuration.getStringProperty(CONFIG_CHARSET_NAME, "UTF-8");
        String compressionFilterClassName = configuration.getStringProperty(CONFIG_COMPRESSION_FILTER, NoneCompressionFilter.class.getName());
        ICompressionFilter compressionFilter = InstantiationFactory.getInstance(configuration).createAndInitialize(ICompressionFilter.class, compressionFilterClassName, configuration);
        String mapFileHandlerClassName = configuration.getStringProperty(CONFIG_MAP_FILE_HANDLER, TextMapFileHandler.class.getName());
        this.mapFileHandler = InstantiationFactory.getInstance(configuration).createAndInitialize(IMapFileHandler.class, mapFileHandlerClassName, configuration);
        this.mapFileHandler.create(logFolder.resolve("kieker.map"), Charset.forName(charsetName));
        String logHandlerClassName = configuration.getStringProperty(CONFIG_LOG_STREAM_HANDLER, TextLogStreamHandler.class.getName());
        Class[] logHandlerSignature = new Class[]{Boolean.class, Integer.class, Charset.class, ICompressionFilter.class, WriterRegistry.class};
        this.logStreamHandler = InstantiationFactory.getInstance(configuration).create(AbstractLogStreamHandler.class, logHandlerClassName, logHandlerSignature, flushLogFile, bufferSize, charset, compressionFilter, this.writerRegistry);
        String logFilePoolHandlerClassName = configuration.getStringProperty(CONFIG_LOG_POOL_FILE_HANDLER, RotatingLogFilePoolHandler.class.getName());
        Class[] logFilePoolHandlerSignature = new Class[]{Path.class, String.class, Integer.class};
        this.logFilePoolHandler = InstantiationFactory.getInstance(configuration).create(ILogFilePoolHandler.class, logFilePoolHandlerClassName, logFilePoolHandlerSignature, logFolder, this.logStreamHandler.getFileExtension(), maxAmountOfFiles);
        Path outputFile = this.logFilePoolHandler.requestFile();
        this.logStreamHandler.initialize(Files.newOutputStream(outputFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), outputFile.getFileName());
    }

    @Override
    public void onNewRegistryEntry(String value, int id) {
        this.mapFileHandler.add(id, value);
    }

    @Override
    public void onStarting() {
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        if (this.logStreamHandler.getNumOfEntries() >= this.maxEntriesInFile) {
            this.createNewLogFile();
        } else if (this.logStreamHandler.getNumOfBytes() >= this.maxBytesInFile) {
            this.createNewLogFile();
        }
        String recordClassName = record.getClass().getName();
        this.writerRegistry.register(recordClassName);
        try {
            this.logStreamHandler.serialize(record, this.writerRegistry.getId(recordClassName));
        }
        catch (IOException e) {
            LOGGER.error("Serializing of a record failed.", e);
        }
    }

    private void createNewLogFile() {
        try {
            this.logStreamHandler.close();
            Path outputFile = this.logFilePoolHandler.requestFile();
            this.logStreamHandler.initialize(Files.newOutputStream(outputFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), outputFile.getFileName());
        }
        catch (IOException ex) {
            LOGGER.error("Switching files in logger failed.", ex);
        }
    }

    @Override
    public void onTerminating() {
        try {
            this.logStreamHandler.close();
            this.mapFileHandler.close();
        }
        catch (IOException ex) {
            LOGGER.error("Closing logger failed.", ex);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        return sb.append(super.toString()).append("\n\t\t").append(PREFIX).append("actualStoragePath").append("='").append(this.logFolderName).append('\'').toString();
    }
}

