/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.jms;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsWriter
extends AbstractMonitoringWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsWriter.class);
    private static final String PREFIX = JmsWriter.class.getName() + ".";
    public static final String CONFIG_PROVIDERURL = PREFIX + "ProviderUrl";
    public static final String CONFIG_TOPIC = PREFIX + "Topic";
    public static final String CONFIG_CONTEXTFACTORYTYPE = PREFIX + "ContextFactoryType";
    public static final String CONFIG_FACTORYLOOKUPNAME = PREFIX + "FactoryLookupName";
    public static final String CONFIG_MESSAGETTL = PREFIX + "MessageTimeToLive";
    public static final String CONFIG_USERNAME = PREFIX + "Username";
    public static final String CONFIG_PASSWORD = PREFIX + "Password";
    private final String configContextFactoryType;
    private final String configProviderUrl;
    private final String configFactoryLookupName;
    private final String configTopic;
    private final long configMessageTimeToLive;
    private final String configUsername;
    private final String configPassword;
    private Session session;
    private Connection connection;
    private MessageProducer sender;

    public JmsWriter(Configuration configuration) {
        super(configuration);
        this.configContextFactoryType = configuration.getStringProperty(CONFIG_CONTEXTFACTORYTYPE);
        this.configProviderUrl = configuration.getStringProperty(CONFIG_PROVIDERURL);
        this.configFactoryLookupName = configuration.getStringProperty(CONFIG_FACTORYLOOKUPNAME);
        this.configTopic = configuration.getStringProperty(CONFIG_TOPIC);
        this.configMessageTimeToLive = configuration.getLongProperty(CONFIG_MESSAGETTL);
        this.configUsername = configuration.getStringProperty(CONFIG_USERNAME);
        this.configPassword = configuration.getStringProperty(CONFIG_PASSWORD);
        this.init();
    }

    private void init() {
        try {
            Destination destination;
            block5: {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("java.naming.factory.initial", this.configContextFactoryType);
                properties.put("java.naming.provider.url", this.configProviderUrl);
                InitialContext context = new InitialContext(properties);
                ConnectionFactory factory = (ConnectionFactory)context.lookup(this.configFactoryLookupName);
                this.connection = this.configUsername.isEmpty() && this.configPassword.isEmpty() ? factory.createConnection() : factory.createConnection(this.configUsername, this.configPassword);
                this.session = this.connection.createSession(false, 1);
                this.connection.start();
                try {
                    destination = (Destination)context.lookup(this.configTopic);
                }
                catch (NameNotFoundException exc) {
                    destination = this.session.createQueue(this.configTopic);
                    if (destination != null) break block5;
                    LOGGER.error("Failed to lookup queue '{}' via JNDI: {} AND failed to create queue", (Object)this.configTopic, (Object)exc.getMessage());
                    throw exc;
                }
            }
            this.sender = this.session.createProducer(destination);
            this.sender.setDeliveryMode(1);
            this.sender.setDisableMessageID(false);
            this.sender.setTimeToLive(this.configMessageTimeToLive);
        }
        catch (NamingException ex) {
            throw new IllegalStateException("NamingException Exception while initializing JMS Writer", ex);
        }
        catch (JMSException ex) {
            throw new IllegalStateException("JMSException Exception while initializing JMS Writer", ex);
        }
    }

    @Override
    public void onStarting() {
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        try {
            ObjectMessage message = this.session.createObjectMessage((Serializable)record);
            this.sender.send((Message)message);
        }
        catch (JMSException ex) {
            throw new IllegalStateException("Error sending jms message", ex);
        }
    }

    @Override
    public void onTerminating() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException ex) {
            LOGGER.error("Error closing connection", ex);
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString()).append("; Session: '").append(this.session.toString()).append("'; Connection: '").append(this.connection.toString()).append("'; MessageProducer: '").append(this.sender.toString()).append('\'');
        return sb.toString();
    }
}

