/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.serializer;

import java.nio.ByteBuffer;
import java.util.Collection;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.dataformat.FormatIdentifier;
import kieker.monitoring.writer.serializer.AbstractMonitoringRecordSerializer;

public abstract class AbstractContainerFormatSerializer
extends AbstractMonitoringRecordSerializer {
    public static final int CONTAINER_IDENTIFIER = FormatIdentifier.CONTAINER_FORMAT.getIdentifierValue();
    private static final int HEADER_SIZE = 8;

    public AbstractContainerFormatSerializer(Configuration configuration) {
        super(configuration);
    }

    @Override
    public final int serializeRecord(IMonitoringRecord record, ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int serializeRecords(Collection<IMonitoringRecord> records, ByteBuffer buffer) {
        buffer.putInt(CONTAINER_IDENTIFIER);
        buffer.putInt(this.getFormatIdentifier());
        int bytesInPayload = this.writeRecords(records, buffer);
        return bytesInPayload + 8;
    }

    protected abstract int writeRecords(Collection<IMonitoringRecord> var1, ByteBuffer var2);

    protected abstract int getFormatIdentifier();
}

