/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.traceWriter;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.AbstractInvalidExecutionTraceProcessingFilter;
import kieker.tools.trace.analysis.systemModel.InvalidExecutionTrace;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Deprecated
@Plugin(description="A filter allowing to write the incoming InvalidExecutionTraces into a configured file", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="outputFn", defaultValue="invalidTraceArtifacts-yyyyMMdd-HHmmssSSS.txt")})
public class InvalidExecutionTraceWriterFilter
extends AbstractInvalidExecutionTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_INVALID_EXECUTION_TRACES = "invalidExecutionTraces";
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FN = "outputFn";
    private static final String ENCODING = "UTF-8";
    private final String outputFn;
    private final PrintStream ps;

    public InvalidExecutionTraceWriterFilter(Configuration configuration, IProjectContext projectContext) throws IOException {
        super(configuration, projectContext);
        this.outputFn = configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN);
        this.ps = new PrintStream(Files.newOutputStream(Paths.get(this.outputFn, new String[0]), new OpenOption[0]), false, ENCODING);
    }

    @Override
    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        LOGGER.debug("Wrote {} execution trace artifact{} to file '{}'", numTraces, numTraces > 1 ? "s" : "", this.outputFn);
    }

    @Override
    public void terminate(boolean error) {
        if (this.ps != null) {
            this.ps.close();
        }
    }

    @Override
    public String getInvalidExecutionTraceInputPortName() {
        return INPUT_PORT_NAME_INVALID_EXECUTION_TRACES;
    }

    @InputPort(name="invalidExecutionTraces", description="Receives the invalid execution traces to be written", eventTypes={InvalidExecutionTrace.class})
    public void newInvalidExecutionTrace(InvalidExecutionTrace et) {
        this.ps.println(et.getInvalidExecutionTraceArtifacts().toString());
        this.reportSuccess(et.getInvalidExecutionTraceArtifacts().getTraceId());
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN, this.outputFn);
        return configuration;
    }
}

