/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.graph;

import java.util.Collection;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractEdge;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractVertex;

public abstract class AbstractGraph<V extends AbstractVertex<V, E, O>, E extends AbstractEdge<V, E, O>, O> {
    public abstract Collection<V> getVertices();

    public void traverse(IGraphVisitor<V, E> visitor) {
        for (AbstractVertex vertex : this.getVertices()) {
            visitor.visitVertex(vertex);
            for (AbstractEdge edge : vertex.getOutgoingEdges()) {
                visitor.visitEdge(edge);
            }
        }
    }

    public void traverseWithVerticesFirst(IGraphVisitor<V, E> visitor) {
        for (AbstractVertex vertex : this.getVertices()) {
            visitor.visitVertex(vertex);
        }
        for (AbstractVertex vertex : this.getVertices()) {
            for (AbstractEdge edge : vertex.getOutgoingEdges()) {
                visitor.visitEdge(edge);
            }
        }
    }

    public static interface IGraphVisitor<V, E> {
        public void visitVertex(V var1);

        public void visitEdge(E var1);
    }
}

