/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.sequenceDiagram;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.util.signature.Signature;
import kieker.tools.trace.analysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.trace.analysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.trace.analysis.systemModel.AbstractMessage;
import kieker.tools.trace.analysis.systemModel.AllocationComponent;
import kieker.tools.trace.analysis.systemModel.AssemblyComponent;
import kieker.tools.trace.analysis.systemModel.ISystemModelElement;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.SynchronousCallMessage;
import kieker.tools.trace.analysis.systemModel.SynchronousReplyMessage;
import kieker.tools.trace.analysis.systemModel.repository.AllocationRepository;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Plugin(description="A filter allowing to write the incoming data into a sequence diagram", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="filename", defaultValue="SequenceDiagram"), @Property(name="shortLabels", defaultValue="true"), @Property(name="SDMode", defaultValue="ASSEMBLY")})
public class SequenceDiagramFilter
extends AbstractMessageTraceProcessingFilter {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FN_BASE = "filename";
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_SHORTLABES = "shortLabels";
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_SDMODE = "SDMode";
    public static final String CONFIG_PROPERTY_VALUE_OUTPUT_FN_BASE_DEFAULT = "SequenceDiagram";
    private static final Logger LOGGER = LoggerFactory.getLogger(SequenceDiagramFilter.class.getCanonicalName());
    private static final String SEQUENCE_PIC_PATH = "META-INF/sequence.pic";
    private static final String SEQUENCE_PIC_CONTENT;
    private static final String ENCODING = "UTF-8";
    private final String outputFnBase;
    private final boolean shortLabels;
    private final SDModes sdmode;

    public SequenceDiagramFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.sdmode = SDModes.valueOf(configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_SDMODE));
        this.outputFnBase = configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN_BASE);
        this.shortLabels = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_OUTPUT_SHORTLABES);
    }

    @Override
    public void printStatusMessage() {
        super.printStatusMessage();
        int numPlots = this.getSuccessCount();
        long lastSuccessTracesId = this.getLastTraceIdSuccess();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Wrote " + numPlots + " sequence diagram" + (numPlots > 1 ? "s" : "") + " to file" + (numPlots > 1 ? "s" : "") + " with name pattern '" + this.outputFnBase + "-<traceId>.pic'");
            LOGGER.debug("Pic files can be converted using the pic2plot tool (package plotutils)");
            LOGGER.debug("Example: pic2plot -T svg " + this.outputFnBase + "-" + (numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".pic > " + this.outputFnBase + "-" + (numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".svg");
        }
    }

    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace mt) {
        try {
            SequenceDiagramFilter.writePicForMessageTrace(mt, this.sdmode, this.outputFnBase + "-" + mt.getTraceId() + ".pic", this.shortLabels);
            this.reportSuccess(mt.getTraceId());
        }
        catch (FileNotFoundException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("File not found", ex);
        }
        catch (UnsupportedEncodingException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("Encoding not supported", ex);
        }
    }

    private static String assemblyComponentLabel(AssemblyComponent component, boolean shortLabels) {
        String assemblyComponentName = component.getName();
        String componentTypePackagePrefx = component.getType().getPackageName();
        String componentTypeIdentifier = component.getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(assemblyComponentName).append(':');
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier);
        return strBuild.toString();
    }

    private static String allocationComponentLabel(AllocationComponent component, boolean shortLabels) {
        String assemblyComponentName = component.getAssemblyComponent().getName();
        String componentTypePackagePrefx = component.getAssemblyComponent().getType().getPackageName();
        String componentTypeIdentifier = component.getAssemblyComponent().getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(assemblyComponentName).append(':');
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier);
        return strBuild.toString();
    }

    private static void picFromMessageTrace(MessageTrace messageTrace, SDModes sdMode, PrintStream ps, boolean shortLabels) {
        ISystemModelElement receiverComponent;
        ISystemModelElement senderComponent;
        List<AbstractMessage> messages = messageTrace.getSequenceAsVector();
        ps.print(".PS\n");
        ps.print(SEQUENCE_PIC_CONTENT + "\n");
        ps.print("boxwid = 1.1;\n");
        ps.print("movewid = 0.5;\n");
        TreeSet<Integer> plottedComponentIds = new TreeSet<Integer>();
        AllocationComponent rootAllocationComponent = AllocationRepository.ROOT_ALLOCATION_COMPONENT;
        String rootDotId = "O" + rootAllocationComponent.getId();
        ps.print("actor(O" + rootAllocationComponent.getId() + ",\"\");\n");
        plottedComponentIds.add(rootAllocationComponent.getId());
        if (sdMode == SDModes.ALLOCATION) {
            for (AbstractMessage me : messages) {
                senderComponent = me.getSendingExecution().getAllocationComponent();
                receiverComponent = me.getReceivingExecution().getAllocationComponent();
                if (!plottedComponentIds.contains(((AllocationComponent)senderComponent).getId())) {
                    ps.print("object(O" + ((AllocationComponent)senderComponent).getId() + ",\"" + ((AllocationComponent)senderComponent).getExecutionContainer().getName() + "::\",\"" + SequenceDiagramFilter.allocationComponentLabel((AllocationComponent)senderComponent, shortLabels) + "\");\n");
                    plottedComponentIds.add(((AllocationComponent)senderComponent).getId());
                }
                if (plottedComponentIds.contains(((AllocationComponent)receiverComponent).getId())) continue;
                ps.print("object(O" + ((AllocationComponent)receiverComponent).getId() + ",\"" + ((AllocationComponent)receiverComponent).getExecutionContainer().getName() + "::\",\"" + SequenceDiagramFilter.allocationComponentLabel((AllocationComponent)receiverComponent, shortLabels) + "\");\n");
                plottedComponentIds.add(((AllocationComponent)receiverComponent).getId());
            }
        } else if (sdMode == SDModes.ASSEMBLY) {
            for (AbstractMessage me : messages) {
                senderComponent = me.getSendingExecution().getAllocationComponent().getAssemblyComponent();
                receiverComponent = me.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
                if (!plottedComponentIds.contains(((AssemblyComponent)senderComponent).getId())) {
                    ps.print("object(O" + ((AssemblyComponent)senderComponent).getId() + ",\"\",\"" + SequenceDiagramFilter.assemblyComponentLabel((AssemblyComponent)senderComponent, shortLabels) + "\");\n");
                    plottedComponentIds.add(((AssemblyComponent)senderComponent).getId());
                }
                if (plottedComponentIds.contains(((AssemblyComponent)receiverComponent).getId())) continue;
                ps.print("object(O" + ((AssemblyComponent)receiverComponent).getId() + ",\"\",\"" + SequenceDiagramFilter.assemblyComponentLabel((AssemblyComponent)receiverComponent, shortLabels) + "\");\n");
                plottedComponentIds.add(((AssemblyComponent)receiverComponent).getId());
            }
        } else {
            LOGGER.error("Invalid mode: {}", (Object)sdMode);
        }
        ps.print("step();\n");
        ps.print("active(" + rootDotId + ");\n");
        boolean first = true;
        for (AbstractMessage me : messages) {
            ISystemModelElement receiverComponent2;
            ISystemModelElement senderComponent2;
            String senderDotId = "-1";
            String receiverDotId = "-1";
            if (sdMode == SDModes.ALLOCATION) {
                senderComponent2 = me.getSendingExecution().getAllocationComponent();
                receiverComponent2 = me.getReceivingExecution().getAllocationComponent();
                senderDotId = "O" + ((AllocationComponent)senderComponent2).getId();
                receiverDotId = "O" + ((AllocationComponent)receiverComponent2).getId();
            } else if (sdMode == SDModes.ASSEMBLY) {
                senderComponent2 = me.getSendingExecution().getAllocationComponent().getAssemblyComponent();
                receiverComponent2 = me.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
                senderDotId = "O" + ((AssemblyComponent)senderComponent2).getId();
                receiverDotId = "O" + ((AssemblyComponent)receiverComponent2).getId();
            } else {
                LOGGER.error("Invalid mode: {}", (Object)sdMode);
            }
            if (me instanceof SynchronousCallMessage) {
                Signature sig = me.getReceivingExecution().getOperation().getSignature();
                StringBuilder msgLabel = new StringBuilder(sig.getName());
                msgLabel.append('(');
                String[] paramList = sig.getParamTypeList();
                if (paramList.length > 0) {
                    msgLabel.append("..");
                }
                msgLabel.append(')');
                if (first) {
                    ps.print("async();\n");
                    first = false;
                } else {
                    ps.print("sync();\n");
                }
                ps.print("message(" + senderDotId + "," + receiverDotId + ", \"" + msgLabel.toString() + "\");\n");
                ps.print("active(" + receiverDotId + ");\n");
                ps.print("step();\n");
                continue;
            }
            if (me instanceof SynchronousReplyMessage) {
                ps.print("step();\n");
                ps.print("async();\n");
                ps.print("rmessage(" + senderDotId + "," + receiverDotId + ", \"\");\n");
                ps.print("inactive(" + senderDotId + ");\n");
                continue;
            }
            LOGGER.error("Message type not supported: {}", (Object)me.getClass().getName());
        }
        ps.print("inactive(" + rootDotId + ");\n");
        ps.print("step();\n");
        Iterator<Object> iterator = plottedComponentIds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ps.print("complete(O" + i + ");\n");
        }
        ps.print("complete(" + rootDotId + ");\n");
        ps.print(".PE\n");
    }

    public static void writePicForMessageTrace(MessageTrace msgTrace, SDModes sdMode, String outputFilename, boolean shortLabels) throws FileNotFoundException, UnsupportedEncodingException {
        PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(outputFilename), false, ENCODING);
        SequenceDiagramFilter.picFromMessageTrace(msgTrace, sdMode, ps, shortLabels);
        ps.flush();
        ps.close();
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN_BASE, this.outputFnBase);
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_SHORTLABES, Boolean.toString(this.shortLabels));
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_SDMODE, this.sdmode.toString());
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        StringBuilder sb = new StringBuilder();
        boolean error = true;
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = SequenceDiagramFilter.class.getClassLoader().getResourceAsStream(SEQUENCE_PIC_PATH);
            reader = new BufferedReader(new InputStreamReader(is, ENCODING));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            error = false;
        }
        catch (IOException exc) {
            AbstractTraceAnalysisFilter.LOGGER.error("Error while reading {}", (Object)SEQUENCE_PIC_PATH, (Object)exc);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AbstractTraceAnalysisFilter.LOGGER.error("Failed to close input stream", ex);
            }
            SEQUENCE_PIC_CONTENT = error ? "copy \"sequence.pic\";" : sb.toString();
        }
    }

    public static enum SDModes {
        ASSEMBLY,
        ALLOCATION;

    }
}

