/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.configuration;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import kieker.analysis.graph.dependency.DependencyGraphCreatorStage;
import kieker.analysis.graph.dependency.DeploymentLevelOperationDependencyGraphBuilderFactory;
import kieker.analysis.graph.dependency.IDependencyGraphBuilderConfiguration;
import kieker.analysis.graph.dependency.dot.DotExportConfigurationFactory;
import kieker.analysis.graph.export.dot.DotFileWriterStage;
import kieker.analysis.graph.export.graphml.GraphMLFileWriterStage;
import kieker.analysis.signature.NameBuilder;
import kieker.analysis.signature.SignatureExtractor;
import kieker.analysis.source.file.DirectoryReaderStage;
import kieker.analysis.source.file.DirectoryScannerStage;
import kieker.analysis.stage.flow.FlowTraceEventMatcher;
import kieker.analysis.stage.general.CallEventMatcher;
import kieker.analysis.stage.general.ControlledEventReleaseStage;
import kieker.analysis.stage.model.CallEvent2OperationCallStage;
import kieker.analysis.stage.model.ExecutionModelAssembler;
import kieker.analysis.stage.model.ExecutionModelAssemblerStage;
import kieker.analysis.stage.model.ModelObjectFromOperationCallAccessorUtils;
import kieker.analysis.stage.model.ModelRepository;
import kieker.analysis.stage.model.OperationAndCallGeneratorStage;
import kieker.analysis.stage.model.StaticModelsAssemblerStage;
import kieker.analysis.stage.model.data.CallEvent;
import kieker.analysis.stage.model.data.OperationEvent;
import kieker.analysis.statistics.CallStatisticsStage;
import kieker.analysis.statistics.FullResponseTimeStatisticsStage;
import kieker.analysis.trace.reconstruction.FlowRecordTraceReconstructionStage;
import kieker.analysis.trace.reconstruction.TraceStatisticsDecoratorStage;
import kieker.analysis.util.stage.AllowedRecordsFilter;
import kieker.analysis.util.stage.trigger.TriggerOnTerminationStage;
import kieker.common.record.flow.IFlowRecord;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.sources.SourceModel;
import kieker.model.analysismodel.sources.SourcesFactory;
import kieker.model.analysismodel.statistics.StatisticsFactory;
import kieker.model.analysismodel.statistics.StatisticsModel;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypeModel;
import teetime.framework.Configuration;
import teetime.framework.Execution;
import teetime.stage.basic.distributor.Distributor;
import teetime.stage.basic.distributor.strategy.CopyByReferenceStrategy;
import teetime.stage.basic.distributor.strategy.IDistributorStrategy;

public class DependencyGraphConfiguration
extends Configuration {
    private static final String PREFIX = DependencyGraphConfiguration.class.getName();
    private static final String KEY_IMPORT_DIRECTORY = System.getProperty(PREFIX + ".importDirectory");
    private static final String KEY_TIME_UNIT_OF_RECODS = System.getProperty(PREFIX + ".timeUnitOfRecods");
    private static final String KEY_EXPORT_DIRECTORY = System.getProperty(PREFIX + ".exportDirectory");
    private static final DotExportConfigurationFactory DOT_EXPORT_CONFIGURATION_FACTORY = new DotExportConfigurationFactory(NameBuilder.forJavaShortOperations());
    private static final String DYNAMIC_SOURCE = "dynamic-source";
    private static final String DEFAULT_NAME = "G";
    private final TypeModel typeModel = TypeFactory.eINSTANCE.createTypeModel();
    private final AssemblyModel assemblyModel = AssemblyFactory.eINSTANCE.createAssemblyModel();
    private final DeploymentModel deploymentModel = DeploymentFactory.eINSTANCE.createDeploymentModel();
    private final ExecutionModel executionModel = ExecutionFactory.eINSTANCE.createExecutionModel();
    private final StatisticsModel statisticsModel = StatisticsFactory.eINSTANCE.createStatisticsModel();
    private final SourceModel sourceModel = SourcesFactory.eINSTANCE.createSourceModel();
    private final SignatureExtractor signatureExtractor = SignatureExtractor.forJava();

    public DependencyGraphConfiguration() {
        this(DEFAULT_NAME, KEY_IMPORT_DIRECTORY, KEY_TIME_UNIT_OF_RECODS, Paths.get(KEY_EXPORT_DIRECTORY, new String[0]));
    }

    public DependencyGraphConfiguration(String name, String importDirectory, String timeUnitOfRecods, Path exportDirectory) {
        this(name, new File(importDirectory), ChronoUnit.valueOf(timeUnitOfRecods), exportDirectory);
    }

    public DependencyGraphConfiguration(String name, File importDirectory, TemporalUnit timeUnitOfRecods, Path exportDirectory) {
        ModelRepository repository = new ModelRepository(name);
        repository.register(TypeModel.class, this.typeModel);
        repository.register(AssemblyModel.class, this.assemblyModel);
        repository.register(DeploymentModel.class, this.deploymentModel);
        repository.register(ExecutionModel.class, this.executionModel);
        repository.register(StatisticsModel.class, this.statisticsModel);
        repository.register(SourceModel.class, this.sourceModel);
        DeploymentLevelOperationDependencyGraphBuilderFactory graphBuilderFactory = new DeploymentLevelOperationDependencyGraphBuilderFactory();
        DirectoryScannerStage directoryScannerStage = new DirectoryScannerStage(importDirectory);
        DirectoryReaderStage directoryReaderStage = new DirectoryReaderStage(false, 80860);
        AllowedRecordsFilter allowedRecordsFilter = new AllowedRecordsFilter();
        Distributor flowRecordDistributor = new Distributor((IDistributorStrategy)new CopyByReferenceStrategy());
        OperationAndCallGeneratorStage operationAndCallGeneratorStage = new OperationAndCallGeneratorStage(true);
        StaticModelsAssemblerStage staticModelsAssembler = new StaticModelsAssemblerStage(this.typeModel, this.assemblyModel, this.deploymentModel, this.sourceModel, DYNAMIC_SOURCE, this.signatureExtractor);
        ControlledEventReleaseStage<OperationEvent, IFlowRecord> flowRecordMerger = new ControlledEventReleaseStage<OperationEvent, IFlowRecord>(new FlowTraceEventMatcher());
        flowRecordMerger.declareActive();
        ControlledEventReleaseStage<OperationEvent, CallEvent> controlCallEventStage = new ControlledEventReleaseStage<OperationEvent, CallEvent>(new CallEventMatcher());
        controlCallEventStage.declareActive();
        Distributor operationCompleteDistributor = new Distributor((IDistributorStrategy)new CopyByReferenceStrategy());
        CallEvent2OperationCallStage callEvent2operationCallStage = new CallEvent2OperationCallStage(repository.getModel(DeploymentModel.class));
        ExecutionModelAssemblerStage executionModelAssemblerStage = new ExecutionModelAssemblerStage(new ExecutionModelAssembler(this.executionModel, this.sourceModel, DYNAMIC_SOURCE));
        CallStatisticsStage callStatisticsStage = new CallStatisticsStage(this.statisticsModel, this.executionModel);
        FlowRecordTraceReconstructionStage traceReconstructor = new FlowRecordTraceReconstructionStage(this.deploymentModel, timeUnitOfRecods);
        TraceStatisticsDecoratorStage traceStatisticsDecorator = new TraceStatisticsDecoratorStage();
        FullResponseTimeStatisticsStage fullStatisticsDecorator = new FullResponseTimeStatisticsStage(this.statisticsModel, ModelObjectFromOperationCallAccessorUtils.DEPLOYED_OPERATION);
        TriggerOnTerminationStage<ModelRepository> onTerminationTrigger = new TriggerOnTerminationStage<ModelRepository>(repository);
        DependencyGraphCreatorStage<IDependencyGraphBuilderConfiguration> dependencyGraphCreator = new DependencyGraphCreatorStage<IDependencyGraphBuilderConfiguration>(new IDependencyGraphBuilderConfiguration(){}, graphBuilderFactory);
        Distributor distributor = new Distributor((IDistributorStrategy)new CopyByReferenceStrategy());
        DotFileWriterStage dotFileWriterStage = new DotFileWriterStage(exportDirectory, DOT_EXPORT_CONFIGURATION_FACTORY.createForDeploymentLevelOperationDependencyGraph());
        GraphMLFileWriterStage graphMLFileWriterStage = new GraphMLFileWriterStage(exportDirectory);
        super.connectPorts(directoryScannerStage.getOutputPort(), directoryReaderStage.getInputPort());
        super.connectPorts(directoryReaderStage.getOutputPort(), allowedRecordsFilter.getInputPort());
        super.connectPorts(allowedRecordsFilter.getOutputPort(), flowRecordDistributor.getInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), operationAndCallGeneratorStage.getInputPort());
        super.connectPorts(operationAndCallGeneratorStage.getOperationOutputPort(), staticModelsAssembler.getInputPort());
        super.connectPorts(staticModelsAssembler.getOutputPort(), operationCompleteDistributor.getInputPort());
        super.connectPorts(operationCompleteDistributor.getNewOutputPort(), controlCallEventStage.getControlInputPort());
        super.connectPorts(operationAndCallGeneratorStage.getCallOutputPort(), controlCallEventStage.getBaseInputPort());
        super.connectPorts(controlCallEventStage.getOutputPort(), callEvent2operationCallStage.getInputPort());
        super.connectPorts(callEvent2operationCallStage.getOutputPort(), executionModelAssemblerStage.getInputPort());
        super.connectPorts(executionModelAssemblerStage.getOutputPort(), callStatisticsStage.getInputPort());
        super.connectPorts(callStatisticsStage.getOutputPort(), fullStatisticsDecorator.getInputPort());
        super.connectPorts(fullStatisticsDecorator.getOutputPort(), onTerminationTrigger.getInputPort());
        super.connectPorts(onTerminationTrigger.getOutputPort(), dependencyGraphCreator.getInputPort());
        super.connectPorts(dependencyGraphCreator.getOutputPort(), distributor.getInputPort());
        super.connectPorts(distributor.getNewOutputPort(), dotFileWriterStage.getInputPort());
        super.connectPorts(distributor.getNewOutputPort(), graphMLFileWriterStage.getInputPort());
        super.connectPorts(operationCompleteDistributor.getNewOutputPort(), flowRecordMerger.getControlInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), traceReconstructor.getInputPort());
        super.connectPorts(traceReconstructor.getOutputPort(), traceStatisticsDecorator.getInputPort());
    }

    public static void main(String[] args) {
        File importDirectory = new File(args[0]);
        Path exportDirectory = Paths.get(args[1], new String[0]);
        DependencyGraphConfiguration configuration = new DependencyGraphConfiguration(DEFAULT_NAME, importDirectory, ChronoUnit.NANOS, exportDirectory);
        Execution execution = new Execution((Configuration)configuration);
        execution.executeBlocking();
    }
}

