/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.export.dot;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kieker.analysis.graph.Direction;
import kieker.analysis.graph.IEdge;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.export.AbstractTransformer;
import kieker.analysis.graph.export.dot.DotExportConfiguration;
import kieker.analysis.graph.util.dot.DotGraphWriter;
import kieker.analysis.graph.util.dot.attributes.DotClusterAttribute;
import kieker.analysis.graph.util.dot.attributes.DotEdgeAttribute;
import kieker.analysis.graph.util.dot.attributes.DotNodeAttribute;

class DotElementExporter
extends AbstractTransformer<Void> {
    protected final DotGraphWriter dotGraphWriter;
    protected final DotExportConfiguration configuration;

    protected DotElementExporter(IGraph graph, DotGraphWriter dotGraphWriter, DotExportConfiguration configuration) {
        super(graph);
        this.dotGraphWriter = dotGraphWriter;
        this.configuration = configuration;
    }

    @Override
    protected void transformVertex(IVertex vertex) {
        try {
            if (vertex.hasChildGraph()) {
                IGraph childGraph = vertex.getChildGraph();
                this.dotGraphWriter.addClusterStart(vertex.getId().toString());
                for (Map.Entry<DotClusterAttribute, Function<IVertex, String>> attribute : this.configuration.getClusterAttributes()) {
                    this.dotGraphWriter.addGraphAttribute(attribute.getKey().toString(), attribute.getValue().apply(vertex));
                }
                DotElementExporter childGraphWriter = new DotElementExporter(childGraph, this.dotGraphWriter, this.configuration);
                childGraphWriter.transform();
                this.dotGraphWriter.addClusterStop();
            } else {
                this.dotGraphWriter.addNode(vertex.getId().toString(), this.getAttributes(vertex));
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    protected void transformEdge(IEdge edge) {
        try {
            String sourceId = edge.getVertex(Direction.OUT).getId().toString();
            String targetId = edge.getVertex(Direction.IN).getId().toString();
            this.dotGraphWriter.addEdge(sourceId, targetId, this.getAttributes(edge));
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException ioException) {
        throw new IllegalStateException(ioException);
    }

    protected Map<String, String> getAttributes(IEdge edge) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<DotEdgeAttribute, Function<IEdge, String>> entry : this.configuration.getEdgeAttributes()) {
            String value = entry.getValue().apply(edge);
            if (value == null) continue;
            attributes.put(entry.getKey().toString(), value);
        }
        return attributes;
    }

    protected Map<String, String> getAttributes(IVertex vertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<DotNodeAttribute, Function<IVertex, String>> entry : this.configuration.getNodeAttributes()) {
            String value = entry.getValue().apply(vertex);
            if (value == null) continue;
            attributes.put(entry.getKey().toString(), value);
        }
        return attributes;
    }

    @Override
    protected void beforeTransformation() {
    }

    @Override
    protected void afterTransformation() {
    }

    @Override
    protected Void getTransformation() {
        return null;
    }
}

