/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.export.graphml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kieker.analysis.graph.Direction;
import kieker.analysis.graph.IEdge;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.export.AbstractTransformer;
import org.graphdrawing.graphml.DataType;
import org.graphdrawing.graphml.EdgeType;
import org.graphdrawing.graphml.GraphEdgedefaultType;
import org.graphdrawing.graphml.GraphType;
import org.graphdrawing.graphml.GraphmlType;
import org.graphdrawing.graphml.KeyForType;
import org.graphdrawing.graphml.KeyType;
import org.graphdrawing.graphml.KeyTypeType;
import org.graphdrawing.graphml.NodeType;

public class GraphMLTransformer
extends AbstractTransformer<GraphmlType> {
    private final GraphType graphType;
    private final Set<String> nodeKeys = new HashSet<String>();
    private final Set<String> edgeKeys = new HashSet<String>();

    public GraphMLTransformer(IGraph graph) {
        super(graph);
        this.graphType = new GraphType();
        this.graphType.setEdgedefault(GraphEdgedefaultType.DIRECTED);
        this.graphType.setId(graph.getName());
    }

    @Override
    protected void transformVertex(IVertex vertex) {
        NodeType nodeType = new NodeType();
        nodeType.setId(vertex.getId().toString());
        List<Object> dataOrPort = nodeType.getDataOrPort();
        for (String propertyKey : vertex.getPropertyKeys()) {
            DataType dataType = new DataType();
            dataType.setKey(propertyKey);
            dataType.setContent(vertex.getProperty(propertyKey).toString());
            dataOrPort.add(dataType);
            this.nodeKeys.add(propertyKey);
        }
        if (vertex.hasChildGraph()) {
            IGraph childGraph = vertex.getChildGraph();
            GraphMLTransformer graphmlTypeTransformer = new GraphMLTransformer(childGraph);
            GraphmlType childGraphmlType = (GraphmlType)graphmlTypeTransformer.transform();
            for (Object childGraphType : childGraphmlType.getGraphOrData()) {
                if (!(childGraphType instanceof GraphType)) continue;
                nodeType.setGraph((GraphType)childGraphType);
            }
            for (KeyType keyType : childGraphmlType.getKey()) {
                KeyForType keyForType = keyType.getFor();
                switch (keyForType) {
                    case NODE: {
                        this.nodeKeys.add(keyType.getAttrName());
                        break;
                    }
                    case EDGE: {
                        this.edgeKeys.add(keyType.getAttrName());
                        break;
                    }
                }
            }
        }
        this.graphType.getDataOrNodeOrEdge().add(nodeType);
    }

    @Override
    protected void transformEdge(IEdge edge) {
        EdgeType edgeType = new EdgeType();
        edgeType.setId(edge.getId().toString());
        edgeType.setSource(edge.getVertex(Direction.OUT).getId().toString());
        edgeType.setTarget(edge.getVertex(Direction.IN).getId().toString());
        List<DataType> data = edgeType.getData();
        for (String propertyKey : edge.getPropertyKeys()) {
            DataType dataType = new DataType();
            dataType.setKey(propertyKey);
            dataType.setContent(edge.getProperty(propertyKey).toString());
            data.add(dataType);
            this.edgeKeys.add(propertyKey);
        }
        this.graphType.getDataOrNodeOrEdge().add(edgeType);
    }

    @Override
    protected GraphmlType getTransformation() {
        KeyType keyType;
        GraphmlType graphmlType = new GraphmlType();
        for (String key : this.nodeKeys) {
            keyType = new KeyType();
            keyType.setId(key);
            keyType.setFor(KeyForType.NODE);
            keyType.setAttrName(key);
            keyType.setAttrType(KeyTypeType.STRING);
            graphmlType.getKey().add(keyType);
        }
        for (String key : this.edgeKeys) {
            keyType = new KeyType();
            keyType.setId(key);
            keyType.setFor(KeyForType.EDGE);
            keyType.setAttrName(key);
            keyType.setAttrType(KeyTypeType.STRING);
            graphmlType.getKey().add(keyType);
        }
        graphmlType.getGraphOrData().add(this.graphType);
        return graphmlType;
    }

    @Override
    protected void beforeTransformation() {
    }

    @Override
    protected void afterTransformation() {
    }
}

