/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kieker.analysis.graph.Direction;
import kieker.analysis.graph.IEdge;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.impl.GraphElementImpl;
import kieker.analysis.graph.impl.GraphImpl;

class VertexImpl
extends GraphElementImpl
implements IVertex {
    protected Map<Object, IEdge> outEdges = new HashMap<Object, IEdge>();
    protected Map<Object, IEdge> inEdges = new HashMap<Object, IEdge>();
    private IGraph childGraph;

    protected VertexImpl(Object id, GraphImpl graph) {
        super(id, graph);
    }

    @Override
    public IGraph addChildGraph() {
        this.childGraph = new GraphImpl(this);
        return this.getChildGraph();
    }

    @Override
    public IGraph addChildGraphIfAbsent() {
        return this.childGraph != null ? this.childGraph : this.addChildGraph();
    }

    @Override
    public boolean hasChildGraph() {
        return this.childGraph != null;
    }

    @Override
    public IGraph getChildGraph() {
        return this.childGraph;
    }

    @Override
    public void removeChildGraph() {
        this.childGraph = null;
    }

    @Override
    public int getDepth() {
        int depth = 0;
        GraphImpl graph = this.graph;
        while (graph.parentVertex != null) {
            graph = graph.parentVertex.graph;
            ++depth;
        }
        return depth;
    }

    @Override
    public Iterable<IEdge> getEdges(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return Iterables.unmodifiableIterable(this.outEdges.values());
        }
        if (direction.equals((Object)Direction.IN)) {
            return Iterables.unmodifiableIterable(this.inEdges.values());
        }
        return Iterables.unmodifiableIterable((Iterable)Iterables.concat(this.outEdges.values(), this.inEdges.values()));
    }

    @Override
    public Iterable<IVertex> getVertices(Direction direction) {
        if (direction.equals((Object)Direction.BOTH)) {
            List vertices = (List)this.getVertices(Direction.IN);
            vertices.addAll((List)this.getVertices(Direction.OUT));
            return vertices;
        }
        ArrayList<IVertex> vertices = new ArrayList<IVertex>();
        for (IEdge edge : this.getEdges(direction)) {
            vertices.add(edge.getVertex(direction.opposite()));
        }
        return vertices;
    }

    @Override
    public void remove() {
        this.graph.removeVertex(this);
    }

    @Override
    public IEdge addEdge(IVertex inVertex) {
        return this.addEdge(null, inVertex);
    }

    @Override
    public IEdge addEdge(Object id, IVertex inVertex) {
        return this.graph.addEdge(id, this, inVertex);
    }

    @Override
    public IEdge addEdgeIfAbsent(Object id, IVertex inVertex) {
        return this.graph.addEdgeIfAbsent(id, this, inVertex);
    }

    protected void addOutEdge(IEdge edge) {
        this.outEdges.put(edge.getId(), edge);
    }

    protected void addInEdge(IEdge edge) {
        this.inEdges.put(edge.getId(), edge);
    }

    protected void removeInEdge(IEdge edge) {
        this.inEdges.remove(edge.getId());
    }

    protected void removeOutEdge(IEdge edge) {
        this.outEdges.remove(edge.getId());
    }
}

