/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.record;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;

@Plugin(description="Forwards incoming records with delays computed from the timestamp values", outputPorts={@OutputPort(name="outputRecords", eventTypes={IMonitoringRecord.class}, description="Outputs the delayed records")}, configuration={@Property(name="numWorkers", defaultValue="1"), @Property(name="additionalShutdownDelaySeconds", defaultValue="5"), @Property(name="warnOnNegativeSchedTimeSeconds", defaultValue="2"), @Property(name="timerPrecision", defaultValue="MILLISECONDS"), @Property(name="accelerationFactor", defaultValue="1")})
public class RealtimeRecordDelayFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_RECORDS = "inputRecords";
    public static final String OUTPUT_PORT_NAME_RECORDS = "outputRecords";
    public static final String CONFIG_PROPERTY_NAME_NUM_WORKERS = "numWorkers";
    public static final String CONFIG_PROPERTY_NAME_ADDITIONAL_SHUTDOWN_DELAY_SECONDS = "additionalShutdownDelaySeconds";
    public static final String CONFIG_PROPERTY_NAME_WARN_NEGATIVE_DELAY_SECONDS = "warnOnNegativeSchedTimeSeconds";
    public static final String CONFIG_PROPERTY_NAME_TIMER = "timerPrecision";
    public static final String CONFIG_PROPERTY_NAME_ACCELERATION_FACTOR = "accelerationFactor";
    public static final double CONFIG_PROPERTY_ACCELERATION_FACTOR_DEFAULT = 1.0;
    private final TimeUnit timeunit = this.recordsTimeUnitFromProjectContext;
    private final String strTimerOrigin;
    private final TimerWithPrecision timer;
    private final double accelerationFactor;
    private final long warnOnNegativeSchedTimeOrigin;
    private final long warnOnNegativeSchedTime;
    private final int numWorkers;
    private final ScheduledThreadPoolExecutor executor;
    private final long shutdownDelay;
    private volatile long startTime = -1L;
    private volatile long firstLoggingTimestamp;
    private volatile long latestSchedulingTime = -1L;

    public RealtimeRecordDelayFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimerWithPrecision tmpTimer;
        this.strTimerOrigin = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMER);
        try {
            tmpTimer = TimerWithPrecision.valueOf(this.strTimerOrigin);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("{} is no valid timer precision! Using MILLISECONDS instead.", (Object)this.strTimerOrigin);
            tmpTimer = TimerWithPrecision.MILLISECONDS;
        }
        this.timer = tmpTimer;
        double accelerationFactorTmp = configuration.getDoubleProperty(CONFIG_PROPERTY_NAME_ACCELERATION_FACTOR);
        if (accelerationFactorTmp <= 0.0) {
            this.logger.warn("Acceleration factor must be > 0. Using default: {}", (Object)1.0);
            accelerationFactorTmp = 1.0;
        }
        this.accelerationFactor = accelerationFactorTmp;
        this.warnOnNegativeSchedTimeOrigin = this.configuration.getLongProperty(CONFIG_PROPERTY_NAME_WARN_NEGATIVE_DELAY_SECONDS);
        this.warnOnNegativeSchedTime = this.timeunit.convert(this.warnOnNegativeSchedTimeOrigin, TimeUnit.SECONDS);
        this.numWorkers = configuration.getIntProperty(CONFIG_PROPERTY_NAME_NUM_WORKERS);
        this.shutdownDelay = this.timeunit.convert(this.configuration.getLongProperty(CONFIG_PROPERTY_NAME_ADDITIONAL_SHUTDOWN_DELAY_SECONDS), TimeUnit.SECONDS);
        this.executor = new ScheduledThreadPoolExecutor(this.numWorkers);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(true);
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="inputRecords", eventTypes={IMonitoringRecord.class}, description="Receives the records to be delayed")
    public final void inputRecord(final IMonitoringRecord monitoringRecord) {
        long currentTime = this.timer.getCurrentTime(this.timeunit);
        RealtimeRecordDelayFilter realtimeRecordDelayFilter = this;
        synchronized (realtimeRecordDelayFilter) {
            long absSchedTime;
            if (this.startTime == -1L) {
                this.firstLoggingTimestamp = monitoringRecord.getLoggingTimestamp();
                this.startTime = currentTime;
            }
            long schedTimeFromNow = monitoringRecord.getLoggingTimestamp() - this.firstLoggingTimestamp - (currentTime - this.startTime);
            if ((schedTimeFromNow = (long)((double)schedTimeFromNow / this.accelerationFactor)) < -this.warnOnNegativeSchedTime) {
                long schedTimeSeconds = TimeUnit.SECONDS.convert(schedTimeFromNow, this.timeunit);
                this.logger.warn("negative scheduling time: {} ({}) / {} (seconds)-> scheduling with a delay of 0", new Object[]{schedTimeFromNow, this.timeunit.toString(), schedTimeSeconds});
            }
            if (schedTimeFromNow < 0L) {
                schedTimeFromNow = 0L;
            }
            if ((absSchedTime = currentTime + schedTimeFromNow) > this.latestSchedulingTime) {
                this.latestSchedulingTime = absSchedTime;
            }
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    RealtimeRecordDelayFilter.this.deliverIndirect(RealtimeRecordDelayFilter.OUTPUT_PORT_NAME_RECORDS, monitoringRecord);
                }
            }, schedTimeFromNow, this.timeunit);
        }
    }

    final boolean deliverIndirect(String outputPortName, Object data) {
        return this.deliver(outputPortName, data);
    }

    @Override
    public void terminate(boolean error) {
        this.executor.shutdown();
        if (!error) {
            long shutdownDelaySecondsFromNow = TimeUnit.SECONDS.convert(this.latestSchedulingTime - this.timer.getCurrentTime(this.timeunit) + this.shutdownDelay, this.timeunit);
            if (shutdownDelaySecondsFromNow < 0L) {
                shutdownDelaySecondsFromNow = 0L;
            }
            shutdownDelaySecondsFromNow += 2L;
            try {
                this.logger.info("Awaiting termination delay of {} seconds ...", (Object)shutdownDelaySecondsFromNow);
                if (!this.executor.awaitTermination(shutdownDelaySecondsFromNow, TimeUnit.SECONDS)) {
                    this.logger.error("Termination delay triggerred before all scheduled records sent");
                }
            }
            catch (InterruptedException e) {
                this.logger.error("Interrupted while awaiting termination delay", (Throwable)e);
            }
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_WARN_NEGATIVE_DELAY_SECONDS, Long.toString(this.warnOnNegativeSchedTimeOrigin));
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUM_WORKERS, Integer.toString(this.numWorkers));
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMER, this.strTimerOrigin);
        configuration.setProperty(CONFIG_PROPERTY_NAME_ACCELERATION_FACTOR, Double.toString(this.accelerationFactor));
        configuration.setProperty(CONFIG_PROPERTY_NAME_ADDITIONAL_SHUTDOWN_DELAY_SECONDS, Long.toString(TimeUnit.SECONDS.convert(this.shutdownDelay, this.timeunit)));
        return configuration;
    }

    private static enum TimerWithPrecision {
        MILLISECONDS{

            @Override
            public long getCurrentTime(TimeUnit timeunit) {
                return timeunit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
        ,
        NANOSECONDS{

            @Override
            public long getCurrentTime(TimeUnit timeunit) {
                return timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            }
        };


        public abstract long getCurrentTime(TimeUnit var1);
    }
}

