/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.list;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;

@Deprecated
@Plugin(programmaticOnly=true, description="A reader that can be prefilled programmatically and that provides these records (mostly used in testing scenarios)", outputPorts={@OutputPort(name="defaultOutput", eventTypes={Object.class})}, configuration={@Property(name="awaitTermination", defaultValue="false", description="Determines whether the read()-method returns immediately or whether it awaits the termination via AnalysisController.terminate()")})
public class ListReader<T>
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME = "defaultOutput";
    public static final String CONFIG_PROPERTY_NAME_AWAIT_TERMINATION = "awaitTermination";
    private final boolean awaitTermination;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final List<T> objects = new CopyOnWriteArrayList<T>();

    public ListReader(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.awaitTermination = this.configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_AWAIT_TERMINATION);
        if (!this.awaitTermination) {
            this.terminationLatch.countDown();
        }
    }

    public void addAllObjects(List<T> records) {
        this.objects.addAll(records);
    }

    public void addObject(T object) {
        this.objects.add(object);
    }

    @Override
    public boolean read() {
        for (T obj : this.objects) {
            super.deliver(OUTPUT_PORT_NAME, obj);
        }
        try {
            if (this.awaitTermination) {
                this.logger.info("Awaiting termination latch to count down ...");
                this.terminationLatch.await();
                this.logger.info("Passed termination latch");
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Reader interrupted while awaiting termination", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void terminate(boolean error) {
        this.terminationLatch.countDown();
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_AWAIT_TERMINATION, Boolean.toString(this.awaitTermination));
        return configuration;
    }
}

