/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.newio;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.newio.IRawDataProcessor;
import kieker.analysis.plugin.reader.newio.IRawDataReader;
import kieker.analysis.plugin.reader.newio.Outcome;
import kieker.analysis.plugin.reader.newio.deserializer.IMonitoringRecordDeserializer;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(description="Generic reader plugin for raw data.", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output port for the decoded records")}, configuration={@Property(name="deserializer", defaultValue="", description="Class name of the deserializer to use"), @Property(name="reader", defaultValue="", description="Class name of the reader to use")})
public class RawDataReaderPlugin
extends AbstractReaderPlugin
implements IRawDataProcessor {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_DESERIALIZER = "deserializer";
    public static final String CONFIG_PROPERTY_READER = "reader";
    private static final Logger LOGGER = LoggerFactory.getLogger(RawDataReaderPlugin.class);
    private final String deserializerClassName;
    private final String readerClassName;
    private final IRawDataReader reader;
    private final IMonitoringRecordDeserializer deserializer;

    public RawDataReaderPlugin(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        String deserializerName;
        String readerName;
        this.readerClassName = readerName = configuration.getStringProperty(CONFIG_PROPERTY_READER);
        this.reader = this.createAndInitializeReader(readerName, configuration, IRawDataReader.class);
        this.deserializerClassName = deserializerName = configuration.getStringProperty(CONFIG_PROPERTY_DESERIALIZER);
        this.deserializer = this.createAndInitializeDeserializer(deserializerName, configuration, projectContext, IMonitoringRecordDeserializer.class);
    }

    private <C> C createAndInitializeReader(String className, Configuration configuration, Class<C> expectedType) {
        C createdInstance = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (!expectedType.isAssignableFrom(clazz)) {
                LOGGER.error("Class {} must implement {}.", (Object)className, (Object)expectedType.getSimpleName());
            }
            createdInstance = (C)this.instantiateReader(clazz, configuration);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Class '{}' not found.", (Object)className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Class {} must implement a (public) constructor that accepts a Configuration.", (Object)className);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error("Unable to instantiate class {}.", (Object)className, (Object)e);
        }
        return createdInstance;
    }

    private <C> C instantiateReader(Class<C> clazz, Configuration configuration) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Configuration configurationToPass = configuration.flatten();
        return clazz.getConstructor(Configuration.class, IRawDataProcessor.class).newInstance(configurationToPass, this);
    }

    private <C> C createAndInitializeDeserializer(String className, Configuration configuration, IProjectContext context, Class<C> expectedType) {
        C createdInstance = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (!expectedType.isAssignableFrom(clazz)) {
                LOGGER.error("Class {} must implement {}.", (Object)className, (Object)expectedType.getSimpleName());
            }
            createdInstance = (C)this.instantiateDeserializer(clazz, configuration, context);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Class '{}' not found.", (Object)className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Class {} must implement a (public) constructor that accepts a Configuration.", (Object)className);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error("Unable to instantiate class {}.", (Object)className, (Object)e);
        }
        return createdInstance;
    }

    private <C> C instantiateDeserializer(Class<C> clazz, Configuration configuration, IProjectContext context) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Configuration configurationToPass = configuration.flatten();
        return clazz.getConstructor(Configuration.class, IProjectContext.class).newInstance(configurationToPass, context);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_DESERIALIZER, this.deserializerClassName);
        configuration.setProperty(CONFIG_PROPERTY_READER, this.readerClassName);
        return configuration;
    }

    @Override
    public boolean init() {
        boolean superInitSuccessful = super.init();
        if (!superInitSuccessful) {
            return false;
        }
        Outcome readerInitOutcome = this.initReader();
        return readerInitOutcome == Outcome.SUCCESS;
    }

    private Outcome initReader() {
        return this.reader.onInitialization();
    }

    @Override
    public boolean read() {
        Outcome readOutcome = this.reader.read();
        return readOutcome == Outcome.SUCCESS;
    }

    @Override
    public void terminate(boolean error) {
        this.terminateReader();
    }

    private Outcome terminateReader() {
        return this.reader.onTermination();
    }

    @Override
    public void decodeAndDeliverRecords(byte[] rawData) {
        this.decodeAndDeliverRecords(ByteBuffer.wrap(rawData), rawData.length);
    }

    @Override
    public void decodeAndDeliverRecords(ByteBuffer rawData, int dataSize) {
        List<IMonitoringRecord> records = this.deserializer.deserializeRecords(rawData, dataSize);
        for (IMonitoringRecord record : records) {
            this.deliver(OUTPUT_PORT_NAME_RECORDS, record);
        }
    }
}

