/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.sink.display;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.common.record.jvm.GCRecord;
import teetime.framework.AbstractConsumerStage;

public class GCDisplayFilter
extends AbstractConsumerStage<GCRecord> {
    public static final String COLLECTION_TIME = "Collection Time";
    public static final String COLLECTION_COUNT = "Collection Count";
    private final XYPlot xyplot;
    private final TimeUnit recordsTimeUnit;

    public GCDisplayFilter(int numberOfEntries, TimeUnit recordsTimeUnit) {
        this.recordsTimeUnit = recordsTimeUnit;
        this.xyplot = new XYPlot(numberOfEntries);
    }

    protected void execute(GCRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(GCRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnit));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname() + " - " + record.getVmName() + " - " + record.getGcName();
        this.xyplot.setEntry(id + " - " + COLLECTION_COUNT, minutesAndSeconds, record.getCollectionCount());
        this.xyplot.setEntry(id + " - " + COLLECTION_TIME, minutesAndSeconds, record.getCollectionTimeMS());
    }

    @Display(name="XYPlot Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }
}

