/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.time;

import java.util.concurrent.TimeUnit;
import kieker.common.record.misc.TimestampRecord;
import teetime.framework.AbstractProducerStage;
import teetime.framework.OutputPort;

public class TimeReaderStage
extends AbstractProducerStage<Object> {
    private final OutputPort<Long> timestampsOutputPort = this.createOutputPort(Long.class);
    private final OutputPort<TimestampRecord> timestampsRecordOutputPort = this.createOutputPort(TimestampRecord.class);
    private final long delay;
    private final TimeUnit timeunit = TimeUnit.NANOSECONDS;
    private final long numberOfImpulses;
    private final boolean infinite;

    public TimeReaderStage(long delay, Long numberOfImpulses) {
        this.delay = delay;
        this.numberOfImpulses = numberOfImpulses;
        this.infinite = numberOfImpulses == null;
    }

    protected void execute() throws Exception {
        while (this.repeatEvent()) {
            long timestamp = this.timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            this.timestampsOutputPort.send((Object)timestamp);
            this.timestampsRecordOutputPort.send((Object)new TimestampRecord(timestamp));
            Thread.sleep(this.delay / 1000L / 1000L);
        }
        this.workCompleted();
    }

    private boolean repeatEvent() {
        if (this.infinite) {
            return true;
        }
        return this.numberOfImpulses > 0L;
    }
}

