/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.model;

import kieker.analysis.stage.model.AbstractSourceModelAssembler;
import kieker.analysis.stage.model.ITraceBasedExecutionModelAssembler;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.execution.AggregatedInvocation;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.Tuple;
import kieker.model.analysismodel.sources.SourceModel;
import kieker.model.analysismodel.trace.OperationCall;

public class TraceBasedExecutionModelAssembler
extends AbstractSourceModelAssembler
implements ITraceBasedExecutionModelAssembler {
    private final ExecutionFactory factory = ExecutionFactory.eINSTANCE;
    private final ExecutionModel executionModel;

    public TraceBasedExecutionModelAssembler(ExecutionModel executionModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.executionModel = executionModel;
    }

    @Override
    public void addOperationCall(OperationCall operationCall) {
        DeployedOperation source = operationCall.getParent() != null ? operationCall.getParent().getOperation() : null;
        DeployedOperation target = operationCall.getOperation();
        this.addExecution(source, target);
    }

    protected void addExecution(DeployedOperation source, DeployedOperation target) {
        Tuple<DeployedOperation, DeployedOperation> key = this.factory.createTuple();
        key.setFirst(source);
        key.setSecond(target);
        if (!this.executionModel.getAggregatedInvocations().containsKey(key)) {
            AggregatedInvocation invocation = this.factory.createAggregatedInvocation();
            invocation.setSource(source);
            invocation.setTarget(target);
            this.updateSourceModel(invocation);
            this.executionModel.getAggregatedInvocations().put(key, (Object)invocation);
        }
    }
}

