/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.select.timestampfilter.components;

import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public abstract class AbstractTimestampFilter<T>
extends AbstractConsumerStage<T> {
    protected final OutputPort<T> recordWithinTimePeriodOutputPort = this.createOutputPort();
    protected final OutputPort<T> recordOutsideTimePeriodOutputPort = this.createOutputPort();
    private final long ignoreBeforeTimestamp;
    private final long ignoreAfterTimestamp;

    public AbstractTimestampFilter(long ignoreBeforeTimestamp, long ignoreAfterTimestamp) {
        this.ignoreBeforeTimestamp = ignoreBeforeTimestamp;
        this.ignoreAfterTimestamp = ignoreAfterTimestamp;
    }

    protected final boolean inRange(long timestamp) {
        return timestamp >= this.ignoreBeforeTimestamp && timestamp <= this.ignoreAfterTimestamp;
    }

    protected void execute(T record) {
        if (this.inRange(this.getRecordSpecificTimestamp(record))) {
            this.recordWithinTimePeriodOutputPort.send(record);
        } else {
            this.recordOutsideTimePeriodOutputPort.send(record);
        }
    }

    protected abstract long getRecordSpecificTimestamp(T var1);

    public OutputPort<T> getRecordWithinTimePeriodOutputPort() {
        return this.recordWithinTimePeriodOutputPort;
    }

    public OutputPort<T> getRecordOutsideTimePeriodOutputPort() {
        return this.recordOutsideTimePeriodOutputPort;
    }
}

