/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.select.traceidfilter.components;

import java.util.Set;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public abstract class AbstractTraceIdFilter<T>
extends AbstractConsumerStage<T> {
    private final boolean acceptAllTraces;
    private final Set<Long> selectedTraceIds;
    private final OutputPort<T> matchingTraceIdOutputPort = this.createOutputPort();
    private final OutputPort<T> mismatchingTraceIdOutputPort = this.createOutputPort();

    public AbstractTraceIdFilter(boolean acceptAllTraces, Set<Long> selectedTraceIds) {
        this.acceptAllTraces = acceptAllTraces;
        this.selectedTraceIds = selectedTraceIds;
    }

    private final boolean acceptId(long traceId) {
        return this.acceptAllTraces || this.selectedTraceIds.contains(traceId);
    }

    protected void execute(T record) {
        if (this.acceptId(this.getRecordsTraceId(record))) {
            this.matchingTraceIdOutputPort.send(record);
        } else {
            this.mismatchingTraceIdOutputPort.send(record);
        }
    }

    protected abstract long getRecordsTraceId(T var1);

    public OutputPort<T> getMatchingTraceIdOutputPort() {
        return this.matchingTraceIdOutputPort;
    }

    public OutputPort<T> getMismatchingTraceIdOutputPort() {
        return this.mismatchingTraceIdOutputPort;
    }
}

