/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics;

import java.util.function.Function;
import kieker.analysis.statistics.calculating.ICalculator;
import kieker.model.analysismodel.statistics.EPredefinedUnits;
import kieker.model.analysismodel.statistics.StatisticRecord;
import kieker.model.analysismodel.statistics.Statistics;
import kieker.model.analysismodel.statistics.StatisticsFactory;
import kieker.model.analysismodel.statistics.StatisticsModel;
import org.eclipse.emf.ecore.EObject;

public class StatisticsDecorator<T> {
    private final StatisticsModel statisticsModel;
    private final EPredefinedUnits unit;
    private final ICalculator<T> statisticCalculator;
    private final Function<T, EObject> objectAccesor;

    public StatisticsDecorator(StatisticsModel statisticsModel, EPredefinedUnits unit, ICalculator<T> statisticCalculator, Function<T, EObject> objectAccesor) {
        this.statisticsModel = statisticsModel;
        this.unit = unit;
        this.statisticCalculator = statisticCalculator;
        this.objectAccesor = objectAccesor;
    }

    public void decorate(T input) {
        StatisticRecord statistic;
        EObject object = this.objectAccesor.apply(input);
        Statistics statistics = (Statistics)this.statisticsModel.getStatistics().get((Object)object);
        if (statistics == null) {
            this.statisticsModel.getStatistics().put((Object)object, (Object)StatisticsFactory.eINSTANCE.createStatistics());
            statistics = (Statistics)this.statisticsModel.getStatistics().get((Object)object);
        }
        if ((statistic = (StatisticRecord)statistics.getStatistics().get((Object)this.unit)) == null) {
            statistics.getStatistics().put((Object)this.unit, (Object)StatisticsFactory.eINSTANCE.createStatisticRecord());
            statistic = (StatisticRecord)statistics.getStatistics().get((Object)this.unit);
        }
        this.statisticCalculator.calculate(statistic, input, object);
    }
}

