/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics.calculating;

import java.util.function.Function;
import kieker.analysis.statistics.calculating.ICalculator;
import kieker.model.analysismodel.statistics.EPropertyType;
import kieker.model.analysismodel.statistics.StatisticRecord;
import org.eclipse.emf.ecore.EObject;

public class TotalCalculator<T>
implements ICalculator<T> {
    private final Function<T, Long> valueAccessor;

    public TotalCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(StatisticRecord statistic, T input, EObject modelObject) {
        long value = this.valueAccessor.apply(input);
        Long oldCount = (Long)statistic.getProperties().get((Object)EPropertyType.TOTAL);
        if (oldCount == null) {
            statistic.getProperties().put((Object)EPropertyType.TOTAL, (Object)value);
        } else {
            long newCount = oldCount + value;
            statistic.getProperties().put((Object)EPropertyType.TOTAL, (Object)newCount);
        }
    }
}

