/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.execution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.trace.AbstractTraceProcessingStage;
import kieker.analysis.trace.execution.AbstractExecutionTraceHashContainer;
import kieker.analysis.trace.execution.ExecutionTraceHashContainerAllocationEquivalence;
import kieker.analysis.trace.execution.ExecutionTraceHashContainerAssemblyEquivalence;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.ExecutionTrace;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.exceptions.InvalidTraceException;
import teetime.framework.OutputPort;

public class TraceEquivalenceClassFilter
extends AbstractTraceProcessingStage<ExecutionTrace> {
    public static final String INPUT_PORT_NAME_EXECUTION_TRACE = "executionTraces";
    public static final String CONFIG_PROPERTY_NAME_EQUIVALENCE_MODE = "equivalenceMode";
    public static final TraceEquivalenceClassModes DEFAULT_EQUIVALENCE_MODE = TraceEquivalenceClassModes.DISABLED;
    private final OutputPort<MessageTrace> messageTraceOutputPort = this.createOutputPort(MessageTrace.class);
    private final OutputPort<ExecutionTrace> executionTraceOutputPort = this.createOutputPort(ExecutionTrace.class);
    private final OutputPort<Map<ExecutionTrace, Integer>> equivalenceMapOutputPort = this.createOutputPort();
    private final TraceEquivalenceClassModes equivalenceMode;
    private final ConcurrentMap<AbstractExecutionTraceHashContainer, AtomicInteger> eTracesEquivClassesMap = new ConcurrentHashMap<AbstractExecutionTraceHashContainer, AtomicInteger>();

    public TraceEquivalenceClassFilter(SystemModelRepository systemModelRepository, TraceEquivalenceClassModes equivalenceMode) {
        super(systemModelRepository);
        this.equivalenceMode = equivalenceMode;
    }

    protected void execute(ExecutionTrace et) throws Exception {
        try {
            if (this.equivalenceMode == TraceEquivalenceClassModes.DISABLED) {
                this.executionTraceOutputPort.send((Object)et);
                this.messageTraceOutputPort.send((Object)et.toMessageTrace(SystemModelRepository.ROOT_EXECUTION));
            } else {
                AbstractExecutionTraceHashContainer polledTraceHashContainer;
                if (this.equivalenceMode == TraceEquivalenceClassModes.ASSEMBLY) {
                    polledTraceHashContainer = new ExecutionTraceHashContainerAssemblyEquivalence(et);
                } else if (this.equivalenceMode == TraceEquivalenceClassModes.ALLOCATION) {
                    polledTraceHashContainer = new ExecutionTraceHashContainerAllocationEquivalence(et);
                } else {
                    this.logger.error("Invalid trace equivalence mode: {}", (Object)this.equivalenceMode);
                    this.reportError(et.getTraceId());
                    return;
                }
                AtomicInteger numOccurences = (AtomicInteger)this.eTracesEquivClassesMap.get(polledTraceHashContainer);
                if (numOccurences == null) {
                    numOccurences = new AtomicInteger(1);
                    this.eTracesEquivClassesMap.put(polledTraceHashContainer, numOccurences);
                    this.executionTraceOutputPort.send((Object)et);
                    this.messageTraceOutputPort.send((Object)et.toMessageTrace(SystemModelRepository.ROOT_EXECUTION));
                } else {
                    numOccurences.incrementAndGet();
                }
            }
            this.reportSuccess(et.getTraceId());
        }
        catch (InvalidTraceException ex) {
            this.logger.error("InvalidTraceException: {}", (Object)ex.getMessage());
            this.reportError(et.getTraceId());
        }
    }

    public ConcurrentMap<ExecutionTrace, Integer> getEquivalenceClassMap() {
        ConcurrentHashMap<ExecutionTrace, Integer> map = new ConcurrentHashMap<ExecutionTrace, Integer>();
        for (Map.Entry entry : this.eTracesEquivClassesMap.entrySet()) {
            map.put(((AbstractExecutionTraceHashContainer)entry.getKey()).getExecutionTrace(), ((AtomicInteger)entry.getValue()).intValue());
        }
        return map;
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        this.equivalenceMapOutputPort.send(this.getEquivalenceClassMap());
        super.onTerminating();
    }

    public OutputPort<Map<ExecutionTrace, Integer>> getEquivalenceMapOutputPort() {
        return this.equivalenceMapOutputPort;
    }

    public OutputPort<ExecutionTrace> getExecutionTraceOutputPort() {
        return this.executionTraceOutputPort;
    }

    public OutputPort<MessageTrace> getMessageTraceOutputPort() {
        return this.messageTraceOutputPort;
    }

    public static enum TraceEquivalenceClassModes {
        DISABLED,
        ASSEMBLY,
        ALLOCATION;

    }
}

