/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.className;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.common.util.filesystem.FSUtil;
import org.slf4j.Logger;

@Deprecated
public class MappingFileParser {
    private static final Map<String, String> FILE_PREFIX_REGISTRY = new HashMap<String, String>();
    protected Logger logger;

    public MappingFileParser(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReaderRegistry<String> parseFromStream(InputStream inputStream) {
        ReaderRegistry<String> classNameRegistry = new ReaderRegistry<String>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = in.readLine()) != null) {
                this.parseTextLine(line, classNameRegistry);
            }
        }
        catch (IOException ex) {
            this.logger.error("Error reading mapping file", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    this.logger.error("Exception while closing input stream for mapping file", (Throwable)ex);
                }
            }
        }
        return classNameRegistry;
    }

    private void parseTextLine(String line, ReaderRegistry<String> stringRegistry) {
        Integer id;
        if (line.length() == 0) {
            return;
        }
        int split = line.indexOf(61);
        if (split == -1) {
            this.logger.error("Failed to find character '=' in line: {" + line + "}. It must consist of a ID=VALUE pair.");
            return;
        }
        String key = line.substring(0, split);
        try {
            id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
        }
        catch (NumberFormatException ex) {
            this.logger.error("Error reading mapping file, id must be integer", (Throwable)ex);
            return;
        }
        String value = FSUtil.decodeNewline(line.substring(split + 1));
        String prevVal = stringRegistry.register(id.intValue(), value);
        if (prevVal != null) {
            this.logger.error("Found addional entry for id='" + id + "', old value was '" + prevVal + "' new value is '" + value + "'");
        }
    }

    public File findMappingFile(File dirPath) {
        File mappingFile = new File(dirPath, "kieker.map");
        if (!mappingFile.exists()) {
            mappingFile = new File(dirPath, "tpmon.map");
            if (mappingFile.exists()) {
                this.logger.info("Directory '" + dirPath + "' contains no file '" + "kieker.map" + "'. Found '" + "tpmon.map" + "' ... switching to legacy mode");
            } else {
                this.logger.warn("No mapping file in directory '" + dirPath.getAbsolutePath() + "'");
                return null;
            }
        }
        return mappingFile;
    }

    public String getFilePrefixFromMappingFile(File mappingFile) {
        return FILE_PREFIX_REGISTRY.get(mappingFile.getName());
    }

    static {
        FILE_PREFIX_REGISTRY.put("kieker.map", "kieker");
        FILE_PREFIX_REGISTRY.put("tpmon.map", "tpmon");
    }
}

