/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.format.binary.file;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.analysis.tt.reader.filesystem.className.ClassNameRegistryRepository;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.OutputPort;

@Deprecated
public class RecordFromBinaryFileCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordFromBinaryFileCreator.class);
    private static final int LONG_BYTES = 8;
    private final ClassNameRegistryRepository classNameRegistryRepository;
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final ByteBuffer buffer;

    public RecordFromBinaryFileCreator(ClassNameRegistryRepository classNameRegistryRepository) {
        this.classNameRegistryRepository = classNameRegistryRepository;
        this.buffer = ByteBuffer.allocate(1024000);
    }

    public void createRecordsFromBinaryFile(File binaryFile, DataInputStream inputStream, OutputPort<IMonitoringRecord> outputPort) throws IOException, MonitoringRecordException {
        LOGGER.info("reading file {}", (Object)binaryFile.getAbsolutePath());
        ReaderRegistry<String> registry = this.classNameRegistryRepository.get(binaryFile.getParentFile());
        BinaryValueDeserializer deserializer = BinaryValueDeserializer.create(this.buffer, registry);
        boolean endOfStreamReached = false;
        while (!endOfStreamReached) {
            byte[] bytes = this.buffer.array();
            int bytesRead = inputStream.read(bytes, this.buffer.position(), this.buffer.remaining());
            this.buffer.position(this.buffer.position() + bytesRead);
            while (bytesRead > 0) {
                bytes = this.buffer.array();
                bytesRead = inputStream.read(bytes, this.buffer.position(), this.buffer.remaining());
                if (bytesRead < 0) continue;
                this.buffer.position(this.buffer.position() + bytesRead);
            }
            if (bytesRead == -1) {
                endOfStreamReached = true;
            }
            this.processBuffer(registry, deserializer, outputPort);
            if (!endOfStreamReached) continue;
            inputStream.close();
        }
    }

    private void processBuffer(ReaderRegistry<String> registry, IValueDeserializer deserializer, OutputPort<IMonitoringRecord> outputPort) throws IOException {
        this.buffer.flip();
        try {
            while (this.buffer.position() + 4 <= this.buffer.limit()) {
                this.buffer.mark();
                IMonitoringRecord record = this.deserializeRecord(registry, deserializer);
                if (record == null) {
                    return;
                }
                outputPort.send((Object)record);
            }
            this.buffer.mark();
            this.buffer.compact();
        }
        catch (BufferUnderflowException ex) {
            LOGGER.warn("Unexpected buffer underflow. Resetting and compacting buffer.", (Throwable)ex);
            this.buffer.reset();
            this.buffer.compact();
            throw ex;
        }
    }

    private IMonitoringRecord deserializeRecord(ReaderRegistry<String> registry, IValueDeserializer deserializer) throws IOException {
        int clazzId = this.buffer.getInt();
        String recordClassName = registry.get(clazzId);
        if (recordClassName == null) {
            LOGGER.error("Missing classname mapping for record type id '{}'", (Object)clazzId);
            return null;
        }
        if (this.buffer.remaining() < 8) {
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        long loggingTimestamp = this.buffer.getLong();
        IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
        if (this.buffer.remaining() < recordFactory.getRecordSizeInBytes()) {
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        try {
            IMonitoringRecord record = recordFactory.create(deserializer);
            record.setLoggingTimestamp(loggingTimestamp);
            return record;
        }
        catch (RecordInstantiationException ex) {
            LOGGER.warn("Failed to create: {} error {}", (Object)recordClassName, (Object)ex);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        catch (BufferUnderflowException ex) {
            LOGGER.warn("Failed to create: {} error {}", (Object)recordClassName, (Object)ex);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
    }
}

