/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util;

import java.util.PriorityQueue;
import java.util.function.BiFunction;

public class RunningMedian<T extends Comparable<T>> {
    private final PriorityQueue<T> maxHeap = new PriorityQueue((x, y) -> y.compareTo(x));
    private final PriorityQueue<T> minHeap = new PriorityQueue((x, y) -> x.compareTo(y));
    private final BiFunction<T, T, T> meanBuilder;

    public RunningMedian() {
        this((x, y) -> x);
    }

    public RunningMedian(BiFunction<T, T, T> meanBuilder) {
        this.meanBuilder = meanBuilder;
    }

    public void add(T element) {
        this.insertToHeap(element);
        this.balanceHeaps();
    }

    private void insertToHeap(T element) {
        if (this.maxHeap.peek() == null || element.compareTo(this.maxHeap.peek()) < 0) {
            this.maxHeap.add(element);
        } else {
            this.minHeap.add(element);
        }
    }

    private void balanceHeaps() {
        if (this.maxHeap.size() - this.minHeap.size() > 1) {
            Comparable maxHeapRoot = (Comparable)this.maxHeap.poll();
            this.minHeap.add(maxHeapRoot);
        } else if (this.minHeap.size() - this.maxHeap.size() > 1) {
            Comparable minHeapRoot = (Comparable)this.minHeap.poll();
            this.maxHeap.add(minHeapRoot);
        }
    }

    public T getMedian() {
        if (this.maxHeap.isEmpty() && this.minHeap.isEmpty()) {
            throw new IllegalStateException("There are no present values for this running median.");
        }
        if (this.maxHeap.size() == this.minHeap.size()) {
            return (T)((Comparable)this.meanBuilder.apply(this.maxHeap.peek(), this.minHeap.peek()));
        }
        if (this.maxHeap.size() > this.minHeap.size()) {
            return (T)((Comparable)this.maxHeap.peek());
        }
        return (T)((Comparable)this.minHeap.peek());
    }

    public static RunningMedian<Integer> forInteger() {
        return new RunningMedian<Integer>((x, y) -> (x + y) / 2);
    }

    public static RunningMedian<Long> forLong() {
        return new RunningMedian<Long>((x, y) -> (x + y) / 2L);
    }

    public static RunningMedian<Double> forDouble() {
        return new RunningMedian<Double>((x, y) -> (x + y) / 2.0);
    }
}

