/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.stage.trigger;

import java.util.ArrayDeque;
import java.util.Deque;
import kieker.analysis.util.stage.trigger.Trigger;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;
import teetime.stage.basic.ITransformation;

public class ForwardOnTriggerStage<T>
extends AbstractStage
implements ITransformation<T, T> {
    private final SendStrategy sendStrategy;
    private final Deque<T> deque = new ArrayDeque<T>();
    private final InputPort<T> inputPort = this.createInputPort();
    private final InputPort<Trigger> triggerInputPort = this.createInputPort();
    private final OutputPort<T> outputPort = this.createOutputPort();

    public ForwardOnTriggerStage() {
        this(SendStrategy.FIFO);
    }

    public ForwardOnTriggerStage(SendStrategy sendStrategy) {
        this.sendStrategy = sendStrategy;
    }

    protected void execute() {
        Trigger trigger;
        Object element = this.getInputPort().receive();
        if (element != null) {
            this.handleElement(element);
        }
        if ((trigger = (Trigger)this.getTriggerInputPort().receive()) != null) {
            this.handleTrigger();
        }
    }

    private void handleElement(T element) {
        this.deque.addLast(element);
    }

    private void handleTrigger() {
        while (this.deque.size() > 0) {
            T element;
            switch (this.sendStrategy) {
                case FIFO: {
                    element = this.deque.removeFirst();
                    break;
                }
                case LIFO: {
                    element = this.deque.removeLast();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.getOutputPort().send(element);
        }
    }

    public InputPort<Trigger> getTriggerInputPort() {
        return this.triggerInputPort;
    }

    public InputPort<T> getInputPort() {
        return this.inputPort;
    }

    public OutputPort<T> getOutputPort() {
        return this.outputPort;
    }

    public static enum SendStrategy {
        FIFO,
        LIFO;

    }
}

