/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.time;

import java.time.temporal.ChronoUnit;
import java.util.function.Function;

public final class ChronoUnitToSymbolMapper
implements Function<ChronoUnit, String> {
    private ChronoUnitToSymbolMapper() {
    }

    @Override
    public String apply(ChronoUnit chronoUnit) {
        switch (chronoUnit) {
            case NANOS: {
                return "ns";
            }
            case MICROS: {
                return "\ufffds";
            }
            case MILLIS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
            case YEARS: {
                return "a";
            }
            case WEEKS: {
                return "weeks";
            }
            case CENTURIES: {
                return "centuries";
            }
            case DECADES: {
                return "decades";
            }
            case ERAS: {
                return "eras";
            }
            case FOREVER: {
                return "forever";
            }
            case HALF_DAYS: {
                return "half days";
            }
            case MILLENNIA: {
                return "millennia";
            }
            case MONTHS: {
                return "months";
            }
        }
        throw new IllegalArgumentException("Unknown ChronoUnit constant");
    }

    public static ChronoUnitToSymbolMapper create() {
        return new ChronoUnitToSymbolMapper();
    }
}

