/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.timeseries;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.stream.Stream;
import kieker.analysis.util.IBackwardsIterable;
import kieker.analysis.util.timeseries.ITimeSeriesPoint;

public class TimeSeries<T extends ITimeSeriesPoint>
implements Iterable<T>,
IBackwardsIterable<T> {
    private final Deque<T> timeSeriesPoints;

    public TimeSeries() {
        this.timeSeriesPoints = new ArrayDeque<T>();
    }

    public TimeSeries(TimeSeries<T> timeSeries) {
        this.timeSeriesPoints = new ArrayDeque<T>(timeSeries.timeSeriesPoints);
    }

    public void appendBegin(T timeSeriesPoint) {
        if (!this.timeSeriesPoints.isEmpty() && !timeSeriesPoint.getTime().isBefore(((ITimeSeriesPoint)this.timeSeriesPoints.getFirst()).getTime())) {
            throw new IllegalArgumentException("Time series point to append is not before current earliest point.");
        }
        this.timeSeriesPoints.addFirst(timeSeriesPoint);
    }

    public void appendEnd(T timeSeriesPoint) {
        if (!this.timeSeriesPoints.isEmpty() && !timeSeriesPoint.getTime().isAfter(((ITimeSeriesPoint)this.timeSeriesPoints.getLast()).getTime())) {
            throw new IllegalArgumentException("Time series point to append is not after current latest point.");
        }
        this.timeSeriesPoints.addLast(timeSeriesPoint);
    }

    public ITimeSeriesPoint getBegin() {
        return (ITimeSeriesPoint)this.timeSeriesPoints.peekFirst();
    }

    public ITimeSeriesPoint getEnd() {
        return (ITimeSeriesPoint)this.timeSeriesPoints.peekLast();
    }

    public ITimeSeriesPoint removeBegin() {
        return (ITimeSeriesPoint)this.timeSeriesPoints.pollFirst();
    }

    public ITimeSeriesPoint removeEnd() {
        return (ITimeSeriesPoint)this.timeSeriesPoints.pollLast();
    }

    @Override
    public Iterator<T> iterator() {
        return this.timeSeriesPoints.iterator();
    }

    @Override
    public Iterator<T> backwardsIterator() {
        return this.timeSeriesPoints.descendingIterator();
    }

    public Stream<T> stream() {
        return this.timeSeriesPoints.stream();
    }

    public int size() {
        return this.timeSeriesPoints.size();
    }

    public boolean isEmpty() {
        return this.timeSeriesPoints.isEmpty();
    }

    public String toString() {
        return this.timeSeriesPoints.toString();
    }
}

