/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SimpleFileLoggingFormatter
extends Formatter {
    protected static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.fillStringBuilderWithMessage(sb, record);
        return sb.toString();
    }

    protected void fillStringBuilderWithMessage(StringBuilder sb, LogRecord record) {
        Date date = new Date(record.getMillis());
        String dateText = this.dateFormat.format(date);
        if (record.getLevel() == Level.WARNING || record.getLevel() == Level.SEVERE) {
            sb.append(record.getLevel().getLocalizedName());
            sb.append(" (").append(dateText).append("): ");
        }
        sb.append(record.getMessage());
        sb.append(LINE_SEPERATOR);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            StackTraceElement[] stackTrace;
            sb.append(thrown.getLocalizedMessage()).append(LINE_SEPERATOR);
            for (StackTraceElement stackTraceElement : stackTrace = thrown.getStackTrace()) {
                sb.append('\t').append(stackTraceElement).append(LINE_SEPERATOR);
            }
        }
    }
}

