/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.controlflow;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BranchingRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 16;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "branchID", "branchingOutcome"};
    public static final long TIMESTAMP = 0L;
    public static final int BRANCH_ID = 0;
    public static final int BRANCHING_OUTCOME = 0;
    private static final long serialVersionUID = 3957750090047819946L;
    private final long timestamp;
    private final int branchID;
    private final int branchingOutcome;

    public BranchingRecord(long timestamp, int branchID, int branchingOutcome) {
        this.timestamp = timestamp;
        this.branchID = branchID;
        this.branchingOutcome = branchingOutcome;
    }

    public BranchingRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.branchID = deserializer.getInt();
        this.branchingOutcome = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putInt(this.getBranchID());
        serializer.putInt(this.getBranchingOutcome());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BranchingRecord castedRecord = (BranchingRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getBranchID() != castedRecord.getBranchID()) {
            return false;
        }
        return this.getBranchingOutcome() == castedRecord.getBranchingOutcome();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getBranchID();
        return code += this.getBranchingOutcome();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getBranchID() {
        return this.branchID;
    }

    public final int getBranchingOutcome() {
        return this.branchingOutcome;
    }

    @Override
    public String toString() {
        String result = "BranchingRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "branchID = ";
        result = result + this.getBranchID() + ", ";
        result = result + "branchingOutcome = ";
        result = result + this.getBranchingOutcome() + ", ";
        return result;
    }
}

