/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class TraceMetadata
extends AbstractMonitoringRecord
implements IFlowRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, Integer.TYPE};
    public static final long NO_PARENT_TRACEID = -1L;
    public static final int NO_PARENT_ORDER_INDEX = -1;
    public static final String NO_SESSION_ID = "<no-session-id>";
    public static final String NO_HOSTNAME = "<default-host>";
    public static final String[] VALUE_NAMES = new String[]{"traceId", "threadId", "sessionId", "hostname", "parentTraceId", "parentOrderId"};
    public static final long TRACE_ID = 0L;
    public static final long THREAD_ID = 0L;
    public static final String SESSION_ID = "<no-session-id>";
    public static final String HOSTNAME = "<default-host>";
    public static final long PARENT_TRACE_ID = -1L;
    public static final int PARENT_ORDER_ID = -1;
    public static final int NEXT_ORDER_ID = 0;
    private static final long serialVersionUID = 2517933148667588979L;
    private long traceId;
    private final long threadId;
    private final String sessionId;
    private final String hostname;
    private final long parentTraceId;
    private final int parentOrderId;
    private int nextOrderId = 0;

    public TraceMetadata(long traceId, long threadId, String sessionId, String hostname, long parentTraceId, int parentOrderId) {
        this.traceId = traceId;
        this.threadId = threadId;
        this.sessionId = sessionId == null ? "<no-session-id>" : sessionId;
        this.hostname = hostname == null ? "<default-host>" : hostname;
        this.parentTraceId = parentTraceId;
        this.parentOrderId = parentOrderId;
    }

    public TraceMetadata(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.traceId = deserializer.getLong();
        this.threadId = deserializer.getLong();
        this.sessionId = deserializer.getString();
        this.hostname = deserializer.getString();
        this.parentTraceId = deserializer.getLong();
        this.parentOrderId = deserializer.getInt();
        this.nextOrderId = 0;
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTraceId());
        serializer.putLong(this.getThreadId());
        serializer.putString(this.getSessionId());
        serializer.putString(this.getHostname());
        serializer.putLong(this.getParentTraceId());
        serializer.putInt(this.getParentOrderId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TraceMetadata castedRecord = (TraceMetadata)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getThreadId() != castedRecord.getThreadId()) {
            return false;
        }
        if (!this.getSessionId().equals(castedRecord.getSessionId())) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (this.getParentTraceId() != castedRecord.getParentTraceId()) {
            return false;
        }
        if (this.getParentOrderId() != castedRecord.getParentOrderId()) {
            return false;
        }
        return this.getNextOrderId() == castedRecord.getNextOrderId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTraceId();
        code += (int)this.getThreadId();
        code += this.getSessionId().hashCode();
        code += this.getHostname().hashCode();
        code += (int)this.getParentTraceId();
        code += this.getParentOrderId();
        return code += this.getNextOrderId();
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final void setTraceId(long traceId) {
        this.traceId = traceId;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final long getParentTraceId() {
        return this.parentTraceId;
    }

    public final int getParentOrderId() {
        return this.parentOrderId;
    }

    public final int getNextOrderId() {
        return this.nextOrderId++;
    }

    @Override
    public String toString() {
        String result = "TraceMetadata: ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "threadId = ";
        result = result + this.getThreadId() + ", ";
        result = result + "sessionId = ";
        result = result + this.getSessionId() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "parentTraceId = ";
        result = result + this.getParentTraceId() + ", ";
        result = result + "parentOrderId = ";
        result = result + this.getParentOrderId() + ", ";
        return result;
    }
}

