/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.io;

import java.nio.ByteBuffer;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.AbstractValueDeserializer;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;

public class BinaryValueDeserializer
extends AbstractValueDeserializer
implements IValueDeserializer {
    private static final byte TRUE_VALUE = 1;
    private final ByteBuffer buffer;
    private final ReaderRegistry<String> stringRegistry;

    protected BinaryValueDeserializer(ByteBuffer buffer, ReaderRegistry<String> stringRegistry) {
        this.buffer = buffer;
        this.stringRegistry = stringRegistry;
    }

    public static BinaryValueDeserializer create(ByteBuffer buffer, ReaderRegistry<String> stringRegistry) {
        return new BinaryValueDeserializer(buffer, stringRegistry);
    }

    @Override
    public boolean getBoolean() {
        return this.getByte() == 1;
    }

    @Override
    public byte getByte() {
        return this.buffer.get();
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public String getString() {
        int stringId = this.getInt();
        return this.stringRegistry.get(stringId);
    }

    @Override
    public <T extends Enum<T>> T getEnumeration(Class<T> clazz) throws RecordInstantiationException {
        int value = this.buffer.getInt();
        return this.enumerationValueOf(clazz, value);
    }

    @Override
    public char getChar() {
        return this.buffer.getChar();
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }
}

