/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.io;

import java.nio.CharBuffer;
import kieker.common.record.io.IValueSerializer;

public class TextValueSerializer
implements IValueSerializer {
    private final CharBuffer buffer;

    protected TextValueSerializer(CharBuffer buffer) {
        this.buffer = buffer;
    }

    public static TextValueSerializer create(CharBuffer buffer) {
        return new TextValueSerializer(buffer);
    }

    @Override
    public void putBoolean(boolean value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putByte(byte value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putChar(char value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putShort(short value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putInt(int value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putLong(long value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putFloat(float value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putDouble(double value) {
        this.buffer.put(";" + value);
    }

    @Override
    public void putBytes(byte[] value) {
        this.buffer.put(";" + String.valueOf(value));
    }

    @Override
    public void putString(String value) {
        if (value != null) {
            this.buffer.put(";" + value.replaceAll(";", "\\;"));
        } else {
            this.buffer.put(";");
        }
    }

    @Override
    public <T extends Enum<T>> void putEnumeration(T value) {
        this.buffer.put(";" + value.ordinal());
    }
}

