/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.remotecontrol;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.remotecontrol.IParameterValueEvent;

public class RemoveParameterValueEvent
extends AbstractMonitoringRecord
implements IParameterValueEvent {
    public static final int SIZE = 12;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"pattern", "name", "value"};
    public static final String PATTERN = "";
    public static final String NAME = "";
    public static final String VALUE = "";
    private static final long serialVersionUID = 3932734275237128548L;
    private final String pattern;
    private final String name;
    private final String value;

    public RemoveParameterValueEvent(String pattern, String name, String value) {
        this.pattern = pattern == null ? "" : pattern;
        this.name = name == null ? "" : name;
        this.value = value == null ? "" : value;
    }

    public RemoveParameterValueEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.pattern = deserializer.getString();
        this.name = deserializer.getString();
        this.value = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getPattern());
        serializer.putString(this.getName());
        serializer.putString(this.getValue());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RemoveParameterValueEvent castedRecord = (RemoveParameterValueEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (!this.getPattern().equals(castedRecord.getPattern())) {
            return false;
        }
        if (!this.getName().equals(castedRecord.getName())) {
            return false;
        }
        return this.getValue().equals(castedRecord.getValue());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getPattern().hashCode();
        code += this.getName().hashCode();
        return code += this.getValue().hashCode();
    }

    @Override
    public final String getPattern() {
        return this.pattern;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        String result = "RemoveParameterValueEvent: ";
        result = result + "pattern = ";
        result = result + this.getPattern() + ", ";
        result = result + "name = ";
        result = result + this.getName() + ", ";
        result = result + "value = ";
        result = result + this.getValue() + ", ";
        return result;
    }
}

