/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra.reader;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDb.class);
    private Cluster cluster;
    private final List<InetSocketAddress> contactPoints;
    private final String keyspace;
    private Session session;
    private final Map<String, PreparedStatement> preparedStatements = new ConcurrentHashMap<String, PreparedStatement>();

    public CassandraDb(String keyspace, List<InetSocketAddress> contactPoints) {
        this.contactPoints = contactPoints;
        this.keyspace = keyspace;
    }

    public void connect() {
        try {
            this.cluster = Cluster.builder().addContactPointsWithPorts(this.contactPoints).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE).withMaxSchemaAgreementWaitSeconds(60).build();
            this.session = this.cluster.connect(this.keyspace);
        }
        catch (AuthenticationException | InvalidQueryException | NoHostAvailableException | IllegalStateException exc) {
            LOGGER.error("Opening Connection to Database failed. {}", (Object)exc.getLocalizedMessage());
        }
    }

    public void disconnect() {
        this.session.close();
        this.cluster.close();
    }

    public ResultSet select(List<String> fields, String table, String whereClause) {
        StringBuilder statement = new StringBuilder(200);
        statement.append("SELECT ");
        if (fields != null && !fields.isEmpty()) {
            for (String s : fields) {
                statement.append(s);
                statement.append(',');
            }
            statement.deleteCharAt(statement.length() - 1);
        } else {
            statement.append('*');
        }
        statement.append(" FROM ");
        statement.append(table);
        if (whereClause != null && !whereClause.isEmpty()) {
            statement.append(" WHERE ");
            statement.append(whereClause);
        }
        return this.execute(this.makeBoundStatement(statement.toString()));
    }

    private BoundStatement makeBoundStatement(String statement) {
        PreparedStatement preparedStatement = this.preparedStatements.get(statement);
        if (preparedStatement == null) {
            preparedStatement = this.session.prepare(statement);
            this.preparedStatements.put(statement, preparedStatement);
        }
        BoundStatement boundStatement = new BoundStatement(preparedStatement);
        boundStatement.setFetchSize(10000);
        return boundStatement;
    }

    private ResultSet execute(BoundStatement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = this.session.execute((Statement)statement);
        }
        catch (NoHostAvailableException | QueryExecutionException | QueryValidationException | UnsupportedFeatureException exc) {
            LOGGER.error("Error executing statement: {}", (Object)exc.getLocalizedMessage());
        }
        return resultSet;
    }
}

